// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PlaywrightTesting.Models
{
    /// <summary> The status of the current operation. </summary>
    public readonly partial struct PlaywrightTestingProvisioningState : IEquatable<PlaywrightTestingProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PlaywrightTestingProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PlaywrightTestingProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string DeletingValue = "Deleting";
        private const string AcceptedValue = "Accepted";

        /// <summary> Resource has been created. </summary>
        public static PlaywrightTestingProvisioningState Succeeded { get; } = new PlaywrightTestingProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static PlaywrightTestingProvisioningState Failed { get; } = new PlaywrightTestingProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static PlaywrightTestingProvisioningState Canceled { get; } = new PlaywrightTestingProvisioningState(CanceledValue);
        /// <summary> Deletion in progress. </summary>
        public static PlaywrightTestingProvisioningState Deleting { get; } = new PlaywrightTestingProvisioningState(DeletingValue);
        /// <summary> Change accepted for processing. </summary>
        public static PlaywrightTestingProvisioningState Accepted { get; } = new PlaywrightTestingProvisioningState(AcceptedValue);
        /// <summary> Determines if two <see cref="PlaywrightTestingProvisioningState"/> values are the same. </summary>
        public static bool operator ==(PlaywrightTestingProvisioningState left, PlaywrightTestingProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PlaywrightTestingProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(PlaywrightTestingProvisioningState left, PlaywrightTestingProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PlaywrightTestingProvisioningState"/>. </summary>
        public static implicit operator PlaywrightTestingProvisioningState(string value) => new PlaywrightTestingProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PlaywrightTestingProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PlaywrightTestingProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
