// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PlaywrightTesting.Models
{
    /// <summary> The free-trial state. </summary>
    public readonly partial struct FreeTrialState : IEquatable<FreeTrialState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FreeTrialState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FreeTrialState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string ExpiredValue = "Expired";

        /// <summary> The free-trial is Active. </summary>
        public static FreeTrialState Active { get; } = new FreeTrialState(ActiveValue);
        /// <summary> The free-trial is Expired. </summary>
        public static FreeTrialState Expired { get; } = new FreeTrialState(ExpiredValue);
        /// <summary> Determines if two <see cref="FreeTrialState"/> values are the same. </summary>
        public static bool operator ==(FreeTrialState left, FreeTrialState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FreeTrialState"/> values are not the same. </summary>
        public static bool operator !=(FreeTrialState left, FreeTrialState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FreeTrialState"/>. </summary>
        public static implicit operator FreeTrialState(string value) => new FreeTrialState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FreeTrialState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FreeTrialState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
