// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.PlaywrightTesting
{
    internal class PlaywrightTestingAccountOperationSource : IOperationSource<PlaywrightTestingAccountResource>
    {
        private readonly ArmClient _client;

        internal PlaywrightTestingAccountOperationSource(ArmClient client)
        {
            _client = client;
        }

        PlaywrightTestingAccountResource IOperationSource<PlaywrightTestingAccountResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = PlaywrightTestingAccountData.DeserializePlaywrightTestingAccountData(document.RootElement);
            return new PlaywrightTestingAccountResource(_client, data);
        }

        async ValueTask<PlaywrightTestingAccountResource> IOperationSource<PlaywrightTestingAccountResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = PlaywrightTestingAccountData.DeserializePlaywrightTestingAccountData(document.RootElement);
            return new PlaywrightTestingAccountResource(_client, data);
        }
    }
}
