// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.Personalizer
{
    /// <summary> The SlotReward. </summary>
    public partial class PersonalizerSlotReward
    {
        /// <summary> Initializes a new instance of PersonalizerSlotReward. </summary>
        /// <param name="slotId"> Slot id for which we are sending the reward. </param>
        /// <param name="value"> Reward to be assigned to slotId. Value should be between -1 and 1 inclusive. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="slotId"/> is null. </exception>
        public PersonalizerSlotReward(string slotId, float value)
        {
            if (slotId == null)
            {
                throw new ArgumentNullException(nameof(slotId));
            }

            SlotId = slotId;
            Value = value;
        }

        /// <summary> Slot id for which we are sending the reward. </summary>
        public string SlotId { get; }
        /// <summary> Reward to be assigned to slotId. Value should be between -1 and 1 inclusive. </summary>
        public float Value { get; }
    }
}
