// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.Personalizer
{
    /// <summary> The SlotResponse. </summary>
    public partial class PersonalizerSlotResult
    {
        /// <summary> Initializes a new instance of PersonalizerSlotResult. </summary>
        /// <param name="slotId"> Id is the slot ID. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="slotId"/> is null. </exception>
        internal PersonalizerSlotResult(string slotId)
        {
            if (slotId == null)
            {
                throw new ArgumentNullException(nameof(slotId));
            }

            SlotId = slotId;
        }

        /// <summary> Initializes a new instance of PersonalizerSlotResult. </summary>
        /// <param name="slotId"> Id is the slot ID. </param>
        /// <param name="rewardActionId"> RewardActionID is the action ID recommended by Personalizer. </param>
        internal PersonalizerSlotResult(string slotId, string rewardActionId)
        {
            SlotId = slotId;
            RewardActionId = rewardActionId;
        }
        /// <summary> RewardActionID is the action ID recommended by Personalizer. </summary>
        public string RewardActionId { get; }
    }
}
