// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.AI.Personalizer
{
    /// <summary> A slot with it&apos;s associated features and list of excluded actions. </summary>
    public partial class PersonalizerSlotOptions
    {
        /// <summary> Initializes a new instance of PersonalizerSlotOptions. </summary>
        /// <param name="id"> Slot ID. </param>
        /// <param name="baselineAction">
        /// The &apos;baseline action&apos; ID for the slot.
        /// The BaselineAction is the Id of the Action your application would use in that slot if Personalizer didn&apos;t exist.
        /// BaselineAction must be defined for every slot.
        /// BaselineAction should never be part of ExcludedActions.
        /// Each slot must have a unique BaselineAction which corresponds to an an action from the event&apos;s Actions list.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> or <paramref name="baselineAction"/> is null. </exception>
        public PersonalizerSlotOptions(string id, string baselineAction)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }
            if (baselineAction == null)
            {
                throw new ArgumentNullException(nameof(baselineAction));
            }

            Id = id;
            Features = new ChangeTrackingList<object>();
            ExcludedActions = new ChangeTrackingList<string>();
            BaselineAction = baselineAction;
        }

        /// <summary> Slot ID. </summary>
        public string Id { get; }
        /// <summary> List of excluded action Ids. </summary>
        public IList<string> ExcludedActions { get; }
        /// <summary>
        /// The &apos;baseline action&apos; ID for the slot.
        /// The BaselineAction is the Id of the Action your application would use in that slot if Personalizer didn&apos;t exist.
        /// BaselineAction must be defined for every slot.
        /// BaselineAction should never be part of ExcludedActions.
        /// Each slot must have a unique BaselineAction which corresponds to an an action from the event&apos;s Actions list.
        /// </summary>
        public string BaselineAction { get; }
    }
}
