// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.Personalizer
{
    /// <summary> The configuration of the service. </summary>
    public partial class PersonalizerServiceProperties
    {
        /// <summary> Initializes a new instance of PersonalizerServiceProperties. </summary>
        /// <param name="rewardWaitTime">
        /// The time span waited until a request is marked with the default reward
        /// and should be between 5 seconds and 2 days.
        /// For example, PT5M (5 mins). For information about the time format,
        /// see http://en.wikipedia.org/wiki/ISO_8601#Durations
        /// </param>
        /// <param name="defaultReward"> The reward given if a reward is not received within the specified wait time. </param>
        /// <param name="rewardAggregation"> The function used to process rewards, if multiple reward scores are received before rewardWaitTime is over. </param>
        /// <param name="explorationPercentage"> The percentage of rank responses that will use exploration. </param>
        /// <param name="modelExportFrequency">
        /// Personalizer will start using the most updated trained model for online ranks automatically every specified time period.
        /// For example, PT5M (5 mins). For information about the time format,
        /// see http://en.wikipedia.org/wiki/ISO_8601#Durations
        /// </param>
        /// <param name="logRetentionDays"> Number of days historical logs are to be maintained. -1 implies the logs will never be deleted. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="rewardAggregation"/> is null. </exception>
        public PersonalizerServiceProperties(TimeSpan rewardWaitTime, float defaultReward, string rewardAggregation, float explorationPercentage, TimeSpan modelExportFrequency, int logRetentionDays)
        {
            if (rewardAggregation == null)
            {
                throw new ArgumentNullException(nameof(rewardAggregation));
            }

            RewardWaitTime = rewardWaitTime;
            DefaultReward = defaultReward;
            RewardAggregation = rewardAggregation;
            ExplorationPercentage = explorationPercentage;
            ModelExportFrequency = modelExportFrequency;
            LogRetentionDays = logRetentionDays;
        }

        /// <summary> Initializes a new instance of PersonalizerServiceProperties. </summary>
        /// <param name="rewardWaitTime">
        /// The time span waited until a request is marked with the default reward
        /// and should be between 5 seconds and 2 days.
        /// For example, PT5M (5 mins). For information about the time format,
        /// see http://en.wikipedia.org/wiki/ISO_8601#Durations
        /// </param>
        /// <param name="defaultReward"> The reward given if a reward is not received within the specified wait time. </param>
        /// <param name="rewardAggregation"> The function used to process rewards, if multiple reward scores are received before rewardWaitTime is over. </param>
        /// <param name="explorationPercentage"> The percentage of rank responses that will use exploration. </param>
        /// <param name="modelExportFrequency">
        /// Personalizer will start using the most updated trained model for online ranks automatically every specified time period.
        /// For example, PT5M (5 mins). For information about the time format,
        /// see http://en.wikipedia.org/wiki/ISO_8601#Durations
        /// </param>
        /// <param name="logMirrorEnabled"> Flag indicates whether log mirroring is enabled. </param>
        /// <param name="logMirrorSasUri"> Azure storage account container SAS URI for log mirroring. </param>
        /// <param name="logRetentionDays"> Number of days historical logs are to be maintained. -1 implies the logs will never be deleted. </param>
        /// <param name="lastConfigurationEditDate"> Last time model training configuration was updated. </param>
        /// <param name="learningMode"> Learning Modes for Personalizer. </param>
        /// <param name="isAutoOptimizationEnabled"> Flag indicating whether Personalizer will automatically optimize Learning Settings by running Offline Evaluations periodically. </param>
        /// <param name="autoOptimizationFrequency">
        /// Frequency of automatic optimization. Only relevant if IsAutoOptimizationEnabled is true.
        /// For example, PT5M (5 mins). For information about the time format,
        /// \r\nsee http://en.wikipedia.org/wiki/ISO_8601#Durations
        /// </param>
        /// <param name="autoOptimizationStartDate"> Date when the first automatic optimization evaluation must be performed. Only relevant if IsAutoOptimizationEnabled is true. </param>
        internal PersonalizerServiceProperties(TimeSpan rewardWaitTime, float defaultReward, string rewardAggregation, float explorationPercentage, TimeSpan modelExportFrequency, bool? logMirrorEnabled, Uri logMirrorSasUri, int logRetentionDays, DateTimeOffset? lastConfigurationEditDate, PersonalizerLearningMode? learningMode, bool? isAutoOptimizationEnabled, TimeSpan? autoOptimizationFrequency, DateTimeOffset? autoOptimizationStartDate)
        {
            RewardWaitTime = rewardWaitTime;
            DefaultReward = defaultReward;
            RewardAggregation = rewardAggregation;
            ExplorationPercentage = explorationPercentage;
            ModelExportFrequency = modelExportFrequency;
            LogMirrorEnabled = logMirrorEnabled;
            LogMirrorSasUri = logMirrorSasUri;
            LogRetentionDays = logRetentionDays;
            LastConfigurationEditDate = lastConfigurationEditDate;
            LearningMode = learningMode;
            IsAutoOptimizationEnabled = isAutoOptimizationEnabled;
            AutoOptimizationFrequency = autoOptimizationFrequency;
            AutoOptimizationStartDate = autoOptimizationStartDate;
        }

        /// <summary>
        /// The time span waited until a request is marked with the default reward
        /// and should be between 5 seconds and 2 days.
        /// For example, PT5M (5 mins). For information about the time format,
        /// see http://en.wikipedia.org/wiki/ISO_8601#Durations
        /// </summary>
        public TimeSpan RewardWaitTime { get; set; }
        /// <summary> The reward given if a reward is not received within the specified wait time. </summary>
        public float DefaultReward { get; set; }
        /// <summary> The function used to process rewards, if multiple reward scores are received before rewardWaitTime is over. </summary>
        public string RewardAggregation { get; set; }
        /// <summary> The percentage of rank responses that will use exploration. </summary>
        public float ExplorationPercentage { get; set; }
        /// <summary>
        /// Personalizer will start using the most updated trained model for online ranks automatically every specified time period.
        /// For example, PT5M (5 mins). For information about the time format,
        /// see http://en.wikipedia.org/wiki/ISO_8601#Durations
        /// </summary>
        public TimeSpan ModelExportFrequency { get; set; }
        /// <summary> Flag indicates whether log mirroring is enabled. </summary>
        public bool? LogMirrorEnabled { get; set; }
        /// <summary> Number of days historical logs are to be maintained. -1 implies the logs will never be deleted. </summary>
        public int LogRetentionDays { get; set; }
        /// <summary> Last time model training configuration was updated. </summary>
        public DateTimeOffset? LastConfigurationEditDate { get; set; }
        /// <summary> Learning Modes for Personalizer. </summary>
        public PersonalizerLearningMode? LearningMode { get; set; }
        /// <summary> Flag indicating whether Personalizer will automatically optimize Learning Settings by running Offline Evaluations periodically. </summary>
        public bool? IsAutoOptimizationEnabled { get; set; }
        /// <summary>
        /// Frequency of automatic optimization. Only relevant if IsAutoOptimizationEnabled is true.
        /// For example, PT5M (5 mins). For information about the time format,
        /// \r\nsee http://en.wikipedia.org/wiki/ISO_8601#Durations
        /// </summary>
        public TimeSpan? AutoOptimizationFrequency { get; set; }
        /// <summary> Date when the first automatic optimization evaluation must be performed. Only relevant if IsAutoOptimizationEnabled is true. </summary>
        public DateTimeOffset? AutoOptimizationStartDate { get; set; }
    }
}
