// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Personalizer
{
    public partial class PersonalizerServiceProperties : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("rewardWaitTime");
            writer.WriteStringValue(RewardWaitTime, "P");
            writer.WritePropertyName("defaultReward");
            writer.WriteNumberValue(DefaultReward);
            writer.WritePropertyName("rewardAggregation");
            writer.WriteStringValue(RewardAggregation);
            writer.WritePropertyName("explorationPercentage");
            writer.WriteNumberValue(ExplorationPercentage);
            writer.WritePropertyName("modelExportFrequency");
            writer.WriteStringValue(ModelExportFrequency, "P");
            if (Optional.IsDefined(LogMirrorEnabled))
            {
                writer.WritePropertyName("logMirrorEnabled");
                writer.WriteBooleanValue(LogMirrorEnabled.Value);
            }
            if (Optional.IsDefined(LogMirrorSasUri))
            {
                writer.WritePropertyName("logMirrorSasUri");
                writer.WriteStringValue(LogMirrorSasUri.AbsoluteUri);
            }
            writer.WritePropertyName("logRetentionDays");
            writer.WriteNumberValue(LogRetentionDays);
            if (Optional.IsDefined(LastConfigurationEditDate))
            {
                writer.WritePropertyName("lastConfigurationEditDate");
                writer.WriteStringValue(LastConfigurationEditDate.Value, "O");
            }
            if (Optional.IsDefined(LearningMode))
            {
                writer.WritePropertyName("learningMode");
                writer.WriteStringValue(LearningMode.Value.ToString());
            }
            if (Optional.IsDefined(IsAutoOptimizationEnabled))
            {
                writer.WritePropertyName("isAutoOptimizationEnabled");
                writer.WriteBooleanValue(IsAutoOptimizationEnabled.Value);
            }
            if (Optional.IsDefined(AutoOptimizationFrequency))
            {
                writer.WritePropertyName("autoOptimizationFrequency");
                writer.WriteStringValue(AutoOptimizationFrequency.Value, "P");
            }
            if (Optional.IsDefined(AutoOptimizationStartDate))
            {
                writer.WritePropertyName("autoOptimizationStartDate");
                writer.WriteStringValue(AutoOptimizationStartDate.Value, "O");
            }
            writer.WriteEndObject();
        }

        internal static PersonalizerServiceProperties DeserializePersonalizerServiceProperties(JsonElement element)
        {
            TimeSpan rewardWaitTime = default;
            float defaultReward = default;
            string rewardAggregation = default;
            float explorationPercentage = default;
            TimeSpan modelExportFrequency = default;
            bool? logMirrorEnabled = default;
            Uri logMirrorSasUri = default;
            int logRetentionDays = default;
            DateTimeOffset? lastConfigurationEditDate = default;
            PersonalizerLearningMode? learningMode = default;
            bool? isAutoOptimizationEnabled = default;
            TimeSpan? autoOptimizationFrequency = default;
            DateTimeOffset? autoOptimizationStartDate = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("rewardWaitTime"))
                {
                    rewardWaitTime = property.Value.GetTimeSpan("P");
                    continue;
                }
                if (property.NameEquals("defaultReward"))
                {
                    defaultReward = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("rewardAggregation"))
                {
                    rewardAggregation = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("explorationPercentage"))
                {
                    explorationPercentage = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("modelExportFrequency"))
                {
                    modelExportFrequency = property.Value.GetTimeSpan("P");
                    continue;
                }
                if (property.NameEquals("logMirrorEnabled"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    logMirrorEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("logMirrorSasUri"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    logMirrorSasUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("logRetentionDays"))
                {
                    logRetentionDays = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("lastConfigurationEditDate"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    lastConfigurationEditDate = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("learningMode"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    learningMode = new PersonalizerLearningMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("isAutoOptimizationEnabled"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    isAutoOptimizationEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("autoOptimizationFrequency"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    autoOptimizationFrequency = property.Value.GetTimeSpan("P");
                    continue;
                }
                if (property.NameEquals("autoOptimizationStartDate"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    autoOptimizationStartDate = property.Value.GetDateTimeOffset("O");
                    continue;
                }
            }
            return new PersonalizerServiceProperties(
                rewardWaitTime,
                defaultReward,
                rewardAggregation,
                explorationPercentage,
                modelExportFrequency,
                logMirrorEnabled,
                logMirrorSasUri,
                logRetentionDays,
                lastConfigurationEditDate,
                learningMode,
                isAutoOptimizationEnabled,
                autoOptimizationFrequency,
                autoOptimizationStartDate);
        }
    }
}
