// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.Personalizer
{
    /// <summary> Reward given to a list of slots. </summary>
    public partial class PersonalizerRewardMultiSlotOptions
    {
        /// <summary> Initializes a new instance of PersonalizerRewardMultiSlotOptions. </summary>
        /// <param name="reward"> List of SlotRewards. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="reward"/> is null. </exception>
        public PersonalizerRewardMultiSlotOptions(IEnumerable<PersonalizerSlotReward> reward)
        {
            if (reward == null)
            {
                throw new ArgumentNullException(nameof(reward));
            }

            Reward = reward.ToList();
        }

        /// <summary> List of SlotRewards. </summary>
        public IList<PersonalizerSlotReward> Reward { get; }
    }
}
