// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Personalizer
{
    public partial class PersonalizerRankedAction
    {
        internal static PersonalizerRankedAction DeserializePersonalizerRankedAction(JsonElement element)
        {
            string id = default;
            float? probability = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("probability"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    probability = property.Value.GetSingle();
                    continue;
                }
            }
            return new PersonalizerRankedAction(id, probability);
        }
    }
}
