// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.Personalizer
{
    /// <summary> An action with its associated features used for ranking. </summary>
    public partial class PersonalizerRankableAction
    {
        /// <summary> Initializes a new instance of PersonalizerRankableAction. </summary>
        /// <param name="id"> Id of the action. </param>
        /// <param name="features"> List of dictionaries containing features. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> or <paramref name="features"/> is null. </exception>
        public PersonalizerRankableAction(string id, IEnumerable<object> features)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }
            if (features == null)
            {
                throw new ArgumentNullException(nameof(features));
            }

            Id = id;
            Features = features.ToList();
        }

        /// <summary> Id of the action. </summary>
        public string Id { get; }
    }
}
