// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Personalizer
{
    /// <summary> The source of the Learning Settings. </summary>
    public readonly partial struct PersonalizerPolicySource : IEquatable<PersonalizerPolicySource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PersonalizerPolicySource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PersonalizerPolicySource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OnlineValue = "Online";
        private const string BaselineValue = "Baseline";
        private const string RandomValue = "Random";
        private const string CustomValue = "Custom";
        private const string OfflineExperimentationValue = "OfflineExperimentation";

        /// <summary> Online. </summary>
        public static PersonalizerPolicySource Online { get; } = new PersonalizerPolicySource(OnlineValue);
        /// <summary> Baseline. </summary>
        public static PersonalizerPolicySource Baseline { get; } = new PersonalizerPolicySource(BaselineValue);
        /// <summary> Random. </summary>
        public static PersonalizerPolicySource Random { get; } = new PersonalizerPolicySource(RandomValue);
        /// <summary> Custom. </summary>
        public static PersonalizerPolicySource Custom { get; } = new PersonalizerPolicySource(CustomValue);
        /// <summary> OfflineExperimentation. </summary>
        public static PersonalizerPolicySource OfflineExperimentation { get; } = new PersonalizerPolicySource(OfflineExperimentationValue);
        /// <summary> Determines if two <see cref="PersonalizerPolicySource"/> values are the same. </summary>
        public static bool operator ==(PersonalizerPolicySource left, PersonalizerPolicySource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PersonalizerPolicySource"/> values are not the same. </summary>
        public static bool operator !=(PersonalizerPolicySource left, PersonalizerPolicySource right) => !left.Equals(right);
        /// <summary> Converts a string to a <see cref="PersonalizerPolicySource"/>. </summary>
        public static implicit operator PersonalizerPolicySource(string value) => new PersonalizerPolicySource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PersonalizerPolicySource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PersonalizerPolicySource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value?.GetHashCode() ?? 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
