// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.Personalizer
{
    /// <summary> The aggregate total of the Offline Evaluation. </summary>
    internal partial class PersonalizerPolicyResultTotalSummary : PersonalizerPolicyResultSummary
    {
        /// <summary> Initializes a new instance of PersonalizerPolicyResultTotalSummary. </summary>
        internal PersonalizerPolicyResultTotalSummary()
        {
        }

        /// <summary> Initializes a new instance of PersonalizerPolicyResultTotalSummary. </summary>
        /// <param name="timeStamp"> Timestamp of the aggregation. </param>
        /// <param name="ipsEstimatorNumerator"> Numerator for IPS estimator. </param>
        /// <param name="ipsEstimatorDenominator"> Denominator for IPS estimator. </param>
        /// <param name="snipsEstimatorDenominator"> Denominator for SNIPS estimator. </param>
        /// <param name="aggregateTimeWindow">
        /// Time window for aggregation.
        /// For example, PT5M (5 mins). For information about the time format,
        /// see http://en.wikipedia.org/wiki/ISO_8601#Durations
        /// </param>
        /// <param name="nonZeroProbability"> Probability of non-zero values for the Policy evaluation. </param>
        /// <param name="sumOfSquares"> Sum of Squares for the Policy evaluation results. </param>
        /// <param name="confidenceInterval"> Gaussian confidence interval for the Policy evaluation. </param>
        /// <param name="averageReward"> Average reward. </param>
        internal PersonalizerPolicyResultTotalSummary(DateTimeOffset? timeStamp, float? ipsEstimatorNumerator, float? ipsEstimatorDenominator, float? snipsEstimatorDenominator, TimeSpan? aggregateTimeWindow, float? nonZeroProbability, float? sumOfSquares, float? confidenceInterval, float? averageReward) : base(timeStamp, ipsEstimatorNumerator, ipsEstimatorDenominator, snipsEstimatorDenominator, aggregateTimeWindow, nonZeroProbability, sumOfSquares, confidenceInterval, averageReward)
        {
        }
    }
}
