// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Personalizer
{
    internal partial class PersonalizerPolicyResultTotalSummary
    {
        internal static PersonalizerPolicyResultTotalSummary DeserializePersonalizerPolicyResultTotalSummary(JsonElement element)
        {
            DateTimeOffset? timeStamp = default;
            float? ipsEstimatorNumerator = default;
            float? ipsEstimatorDenominator = default;
            float? snipsEstimatorDenominator = default;
            TimeSpan? aggregateTimeWindow = default;
            float? nonZeroProbability = default;
            float? sumOfSquares = default;
            float? confidenceInterval = default;
            float? averageReward = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("timeStamp"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    timeStamp = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("ipsEstimatorNumerator"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    ipsEstimatorNumerator = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("ipsEstimatorDenominator"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    ipsEstimatorDenominator = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("snipsEstimatorDenominator"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    snipsEstimatorDenominator = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("aggregateTimeWindow"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    aggregateTimeWindow = property.Value.GetTimeSpan("P");
                    continue;
                }
                if (property.NameEquals("nonZeroProbability"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    nonZeroProbability = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("sumOfSquares"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    sumOfSquares = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("confidenceInterval"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    confidenceInterval = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("averageReward"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    averageReward = property.Value.GetSingle();
                    continue;
                }
            }
            return new PersonalizerPolicyResultTotalSummary(timeStamp, ipsEstimatorNumerator, ipsEstimatorDenominator, snipsEstimatorDenominator, aggregateTimeWindow, nonZeroProbability, sumOfSquares, confidenceInterval, averageReward);
        }
    }
}
