// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.Personalizer
{
    /// <summary> This class contains the summary of evaluating a policy on a counterfactual evaluation. </summary>
    public partial class PersonalizerPolicyResultSummary
    {
        /// <summary> Initializes a new instance of PersonalizerPolicyResultSummary. </summary>
        internal PersonalizerPolicyResultSummary()
        {
        }

        /// <summary> Initializes a new instance of PersonalizerPolicyResultSummary. </summary>
        /// <param name="timeStamp"> Timestamp of the aggregation. </param>
        /// <param name="ipsEstimatorNumerator"> Numerator for IPS estimator. </param>
        /// <param name="ipsEstimatorDenominator"> Denominator for IPS estimator. </param>
        /// <param name="snipsEstimatorDenominator"> Denominator for SNIPS estimator. </param>
        /// <param name="aggregateTimeWindow">
        /// Time window for aggregation.
        /// For example, PT5M (5 mins). For information about the time format,
        /// see http://en.wikipedia.org/wiki/ISO_8601#Durations
        /// </param>
        /// <param name="nonZeroProbability"> Probability of non-zero values for the Policy evaluation. </param>
        /// <param name="sumOfSquares"> Sum of Squares for the Policy evaluation results. </param>
        /// <param name="confidenceInterval"> Gaussian confidence interval for the Policy evaluation. </param>
        /// <param name="averageReward"> Average reward. </param>
        internal PersonalizerPolicyResultSummary(DateTimeOffset? timeStamp, float? ipsEstimatorNumerator, float? ipsEstimatorDenominator, float? snipsEstimatorDenominator, TimeSpan? aggregateTimeWindow, float? nonZeroProbability, float? sumOfSquares, float? confidenceInterval, float? averageReward)
        {
            TimeStamp = timeStamp;
            IpsEstimatorNumerator = ipsEstimatorNumerator;
            IpsEstimatorDenominator = ipsEstimatorDenominator;
            SnipsEstimatorDenominator = snipsEstimatorDenominator;
            AggregateTimeWindow = aggregateTimeWindow;
            NonZeroProbability = nonZeroProbability;
            SumOfSquares = sumOfSquares;
            ConfidenceInterval = confidenceInterval;
            AverageReward = averageReward;
        }

        /// <summary> Timestamp of the aggregation. </summary>
        public DateTimeOffset? TimeStamp { get; }
        /// <summary> Numerator for IPS estimator. </summary>
        public float? IpsEstimatorNumerator { get; }
        /// <summary> Denominator for IPS estimator. </summary>
        public float? IpsEstimatorDenominator { get; }
        /// <summary> Denominator for SNIPS estimator. </summary>
        public float? SnipsEstimatorDenominator { get; }
        /// <summary>
        /// Time window for aggregation.
        /// For example, PT5M (5 mins). For information about the time format,
        /// see http://en.wikipedia.org/wiki/ISO_8601#Durations
        /// </summary>
        public TimeSpan? AggregateTimeWindow { get; }
        /// <summary> Probability of non-zero values for the Policy evaluation. </summary>
        public float? NonZeroProbability { get; }
        /// <summary> Sum of Squares for the Policy evaluation results. </summary>
        public float? SumOfSquares { get; }
        /// <summary> Gaussian confidence interval for the Policy evaluation. </summary>
        public float? ConfidenceInterval { get; }
        /// <summary> Average reward. </summary>
        public float? AverageReward { get; }
    }
}
