// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Core;

namespace Azure.AI.Personalizer
{
    /// <summary> This class contains the Learning Settings information and the results of the Offline Evaluation using that policy. </summary>
    public partial class PersonalizerPolicyResult
    {
        /// <summary> Initializes a new instance of PersonalizerPolicyResult. </summary>
        internal PersonalizerPolicyResult()
        {
            Summary = new ChangeTrackingList<PersonalizerPolicyResultSummary>();
        }

        /// <summary> Initializes a new instance of PersonalizerPolicyResult. </summary>
        /// <param name="name"> The name of the Learning Settings. </param>
        /// <param name="arguments"> The arguments of the Learning Settings. </param>
        /// <param name="policySource"> The source of the Learning Settings. </param>
        /// <param name="summary"> The aggregate results of the Offline Evaluation. </param>
        /// <param name="totalSummary"> The aggregate total of the Offline Evaluation. </param>
        internal PersonalizerPolicyResult(string name, string arguments, PersonalizerPolicySource? policySource, IReadOnlyList<PersonalizerPolicyResultSummary> summary, PersonalizerPolicyResultSummary totalSummary)
        {
            Name = name;
            Arguments = arguments;
            PolicySource = policySource;
            Summary = summary;
            TotalSummary = totalSummary;
        }

        /// <summary> The name of the Learning Settings. </summary>
        public string Name { get; }
        /// <summary> The arguments of the Learning Settings. </summary>
        public string Arguments { get; }
        /// <summary> The source of the Learning Settings. </summary>
        public PersonalizerPolicySource? PolicySource { get; }
        /// <summary> The aggregate results of the Offline Evaluation. </summary>
        public IReadOnlyList<PersonalizerPolicyResultSummary> Summary { get; }
    }
}
