// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.Personalizer
{
    /// <summary> Reference to the policy within the evaluation. </summary>
    public partial class PersonalizerPolicyReferenceOptions
    {
        /// <summary> Initializes a new instance of PersonalizerPolicyReferenceOptions. </summary>
        /// <param name="evaluationId"> Evaluation Id of the evaluation. </param>
        /// <param name="policyName"> Name of the learning settings. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="evaluationId"/> or <paramref name="policyName"/> is null. </exception>
        public PersonalizerPolicyReferenceOptions(string evaluationId, string policyName)
        {
            if (evaluationId == null)
            {
                throw new ArgumentNullException(nameof(evaluationId));
            }
            if (policyName == null)
            {
                throw new ArgumentNullException(nameof(policyName));
            }

            EvaluationId = evaluationId;
            PolicyName = policyName;
        }

        /// <summary> Evaluation Id of the evaluation. </summary>
        public string EvaluationId { get; }
        /// <summary> Name of the learning settings. </summary>
        public string PolicyName { get; }
    }
}
