// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Core;

namespace Azure.AI.Personalizer
{
    /// <summary> The MultiSlotRankResponse. </summary>
    public partial class PersonalizerMultiSlotRankResult
    {
        /// <summary> Initializes a new instance of PersonalizerMultiSlotRankResult. </summary>
        internal PersonalizerMultiSlotRankResult()
        {
            Slots = new ChangeTrackingList<PersonalizerSlotResult>();
        }

        /// <summary> Initializes a new instance of PersonalizerMultiSlotRankResult. </summary>
        /// <param name="slots"> Each slot has a corresponding rewardActionID which is the action ID recommended by Personalizer. </param>
        /// <param name="eventId"> The eventId for the round trip from request to response. </param>
        internal PersonalizerMultiSlotRankResult(IReadOnlyList<PersonalizerSlotResult> slots, string eventId)
        {
            Slots = slots;
            EventId = eventId;
        }

        /// <summary> Each slot has a corresponding rewardActionID which is the action ID recommended by Personalizer. </summary>
        public IReadOnlyList<PersonalizerSlotResult> Slots { get; }
        /// <summary> The eventId for the round trip from request to response. </summary>
        public string EventId { get; }
    }
}
