// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Personalizer
{
    internal partial class PersonalizerLogPropertiesDateRange
    {
        internal static PersonalizerLogPropertiesDateRange DeserializePersonalizerLogPropertiesDateRange(JsonElement element)
        {
            DateTimeOffset? @from = default;
            DateTimeOffset? to = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("from"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    @from = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("to"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    to = property.Value.GetDateTimeOffset("O");
                    continue;
                }
            }
            return new PersonalizerLogPropertiesDateRange(@from, to);
        }
    }
}
