// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Personalizer
{
    /// <summary> The status of the job processing the evaluation. </summary>
    public readonly partial struct PersonalizerEvaluationJobStatus : IEquatable<PersonalizerEvaluationJobStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PersonalizerEvaluationJobStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PersonalizerEvaluationJobStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CompletedValue = "completed";
        private const string PendingValue = "pending";
        private const string FailedValue = "failed";
        private const string NotSubmittedValue = "notSubmitted";
        private const string TimeoutValue = "timeout";
        private const string OptimalPolicyAppliedValue = "optimalPolicyApplied";
        private const string OnlinePolicyRetainedValue = "onlinePolicyRetained";

        /// <summary> completed. </summary>
        public static PersonalizerEvaluationJobStatus Completed { get; } = new PersonalizerEvaluationJobStatus(CompletedValue);
        /// <summary> pending. </summary>
        public static PersonalizerEvaluationJobStatus Pending { get; } = new PersonalizerEvaluationJobStatus(PendingValue);
        /// <summary> failed. </summary>
        public static PersonalizerEvaluationJobStatus Failed { get; } = new PersonalizerEvaluationJobStatus(FailedValue);
        /// <summary> notSubmitted. </summary>
        public static PersonalizerEvaluationJobStatus NotSubmitted { get; } = new PersonalizerEvaluationJobStatus(NotSubmittedValue);
        /// <summary> timeout. </summary>
        public static PersonalizerEvaluationJobStatus Timeout { get; } = new PersonalizerEvaluationJobStatus(TimeoutValue);
        /// <summary> optimalPolicyApplied. </summary>
        public static PersonalizerEvaluationJobStatus OptimalPolicyApplied { get; } = new PersonalizerEvaluationJobStatus(OptimalPolicyAppliedValue);
        /// <summary> onlinePolicyRetained. </summary>
        public static PersonalizerEvaluationJobStatus OnlinePolicyRetained { get; } = new PersonalizerEvaluationJobStatus(OnlinePolicyRetainedValue);
        /// <summary> Determines if two <see cref="PersonalizerEvaluationJobStatus"/> values are the same. </summary>
        public static bool operator ==(PersonalizerEvaluationJobStatus left, PersonalizerEvaluationJobStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PersonalizerEvaluationJobStatus"/> values are not the same. </summary>
        public static bool operator !=(PersonalizerEvaluationJobStatus left, PersonalizerEvaluationJobStatus right) => !left.Equals(right);
        /// <summary> Converts a string to a <see cref="PersonalizerEvaluationJobStatus"/>. </summary>
        public static implicit operator PersonalizerEvaluationJobStatus(string value) => new PersonalizerEvaluationJobStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PersonalizerEvaluationJobStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PersonalizerEvaluationJobStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value?.GetHashCode() ?? 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
