// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.AI.Personalizer
{
    /// <summary> A Counterfactual Evaluation. </summary>
    public partial class PersonalizerEvaluation
    {
        /// <summary> Initializes a new instance of PersonalizerEvaluation. </summary>
        internal PersonalizerEvaluation()
        {
            PolicyResults = new ChangeTrackingList<PersonalizerPolicyResult>();
            FeatureImportance = new ChangeTrackingList<IList<string>>();
        }

        /// <summary> Initializes a new instance of PersonalizerEvaluation. </summary>
        /// <param name="id"> The ID of the evaluation. </param>
        /// <param name="name"> The name of the evaluation. </param>
        /// <param name="startTime"> The start time of the evaluation. </param>
        /// <param name="endTime"> The end time of the evaluation. </param>
        /// <param name="jobId"> The ID of the job processing the evaluation. </param>
        /// <param name="status"> The status of the job processing the evaluation. </param>
        /// <param name="policyResults"> The results of the evaluation. </param>
        /// <param name="featureImportance"> Feature Importance. </param>
        /// <param name="evaluationType"> Evaluation type (manual or through Automatic Optimization). </param>
        /// <param name="optimalPolicy"> Thr optimal policy. </param>
        /// <param name="creationTime"> Creation time. </param>
        internal PersonalizerEvaluation(string id, string name, DateTimeOffset? startTime, DateTimeOffset? endTime, string jobId, PersonalizerEvaluationJobStatus? status, IReadOnlyList<PersonalizerPolicyResult> policyResults, IReadOnlyList<IList<string>> featureImportance, PersonalizerEvaluationType? evaluationType, string optimalPolicy, DateTimeOffset? creationTime)
        {
            Id = id;
            Name = name;
            StartTime = startTime;
            EndTime = endTime;
            JobId = jobId;
            Status = status;
            PolicyResults = policyResults;
            FeatureImportance = featureImportance;
            EvaluationType = evaluationType;
            OptimalPolicy = optimalPolicy;
            CreationTime = creationTime;
        }

        /// <summary> The ID of the evaluation. </summary>
        public string Id { get; }
        /// <summary> The name of the evaluation. </summary>
        public string Name { get; }
        /// <summary> The start time of the evaluation. </summary>
        public DateTimeOffset? StartTime { get; }
        /// <summary> The end time of the evaluation. </summary>
        public DateTimeOffset? EndTime { get; }
        /// <summary> The ID of the job processing the evaluation. </summary>
        public string JobId { get; }
        /// <summary> The status of the job processing the evaluation. </summary>
        public PersonalizerEvaluationJobStatus? Status { get; }
        /// <summary> The results of the evaluation. </summary>
        public IReadOnlyList<PersonalizerPolicyResult> PolicyResults { get; }
        /// <summary> Feature Importance. </summary>
        public IReadOnlyList<IList<string>> FeatureImportance { get; }
        /// <summary> Evaluation type (manual or through Automatic Optimization). </summary>
        public PersonalizerEvaluationType? EvaluationType { get; }
        /// <summary> Thr optimal policy. </summary>
        public string OptimalPolicy { get; }
        /// <summary> Creation time. </summary>
        public DateTimeOffset? CreationTime { get; }
    }
}
