// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Personalizer
{
    public partial class PersonalizerEvaluation
    {
        internal static PersonalizerEvaluation DeserializePersonalizerEvaluation(JsonElement element)
        {
            string id = default;
            string name = default;
            DateTimeOffset? startTime = default;
            DateTimeOffset? endTime = default;
            string jobId = default;
            PersonalizerEvaluationJobStatus? status = default;
            IReadOnlyList<PersonalizerPolicyResult> policyResults = default;
            IReadOnlyList<IList<string>> featureImportance = default;
            PersonalizerEvaluationType? evaluationType = default;
            string optimalPolicy = default;
            DateTimeOffset? creationTime = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("name"))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("startTime"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    startTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("endTime"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    endTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("jobId"))
                {
                    jobId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("status"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    status = new PersonalizerEvaluationJobStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("policyResults"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    List<PersonalizerPolicyResult> array = new List<PersonalizerPolicyResult>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(PersonalizerPolicyResult.DeserializePersonalizerPolicyResult(item));
                    }
                    policyResults = array;
                    continue;
                }
                if (property.NameEquals("featureImportance"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    List<IList<string>> array = new List<IList<string>>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        List<string> array0 = new List<string>();
                        foreach (var item0 in item.EnumerateArray())
                        {
                            array0.Add(item0.GetString());
                        }
                        array.Add(array0);
                    }
                    featureImportance = array;
                    continue;
                }
                if (property.NameEquals("evaluationType"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    evaluationType = new PersonalizerEvaluationType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("optimalPolicy"))
                {
                    optimalPolicy = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("creationTime"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    creationTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
            }
            return new PersonalizerEvaluation(
                id,
                name,
                startTime,
                endTime,
                jobId,
                status,
                policyResults ?? new ChangeTrackingList<PersonalizerPolicyResult>(),
                featureImportance ?? new ChangeTrackingList<IList<string>>(),
                evaluationType,
                optimalPolicy,
                creationTime);
        }
    }
}
