// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Personalizer.Models
{
    /// <summary> Error Codes returned by Personalizer. </summary>
    internal readonly partial struct PersonalizerErrorCode : IEquatable<PersonalizerErrorCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PersonalizerErrorCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PersonalizerErrorCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BadRequestValue = "BadRequest";
        private const string InvalidServiceConfigurationValue = "InvalidServiceConfiguration";
        private const string InvalidLearningModeServiceConfigurationValue = "InvalidLearningModeServiceConfiguration";
        private const string InvalidPolicyConfigurationValue = "InvalidPolicyConfiguration";
        private const string InvalidPolicyContractValue = "InvalidPolicyContract";
        private const string InvalidEvaluationContractValue = "InvalidEvaluationContract";
        private const string DuplicateCustomPolicyNamesValue = "DuplicateCustomPolicyNames";
        private const string NoLogsExistInDateRangeValue = "NoLogsExistInDateRange";
        private const string LogsSizeExceedAllowedLimitValue = "LogsSizeExceedAllowedLimit";
        private const string InvalidRewardRequestValue = "InvalidRewardRequest";
        private const string InvalidEventIdToActivateValue = "InvalidEventIdToActivate";
        private const string InvalidRankRequestValue = "InvalidRankRequest";
        private const string InvalidExportLogsRequestValue = "InvalidExportLogsRequest";
        private const string InvalidRequestValue = "InvalidRequest";
        private const string InvalidContainerValue = "InvalidContainer";
        private const string InvalidModelMetadataValue = "InvalidModelMetadata";
        private const string ApprenticeModeNeverTurnedOnValue = "ApprenticeModeNeverTurnedOn";
        private const string MissingAppIdValue = "MissingAppId";
        private const string InvalidRewardWaitTimeValue = "InvalidRewardWaitTime";
        private const string InvalidLogRetentionDaysValue = "InvalidLogRetentionDays";
        private const string InvalidMultiSlotApiAccessValue = "InvalidMultiSlotApiAccess";
        private const string PayloadSizeExceededValue = "PayloadSizeExceeded";
        private const string InvalidModelImportSignatureValue = "InvalidModelImportSignature";
        private const string InvalidModelImportFormatValue = "InvalidModelImportFormat";
        private const string InvalidApiAccessValue = "InvalidApiAccess";
        private const string ModelFileAccessDeniedValue = "ModelFileAccessDenied";
        private const string ProblemTypeIncompatibleWithAutoOptimizationValue = "ProblemTypeIncompatibleWithAutoOptimization";
        private const string ResourceNotFoundValue = "ResourceNotFound";
        private const string FrontEndNotFoundValue = "FrontEndNotFound";
        private const string EvaluationNotFoundValue = "EvaluationNotFound";
        private const string LearningSettingsNotFoundValue = "LearningSettingsNotFound";
        private const string EvaluationModelNotFoundValue = "EvaluationModelNotFound";
        private const string LogsPropertiesNotFoundValue = "LogsPropertiesNotFound";
        private const string ModelRankingErrorValue = "ModelRankingError";
        private const string InternalServerErrorValue = "InternalServerError";
        private const string RankNullResponseValue = "RankNullResponse";
        private const string UpdateConfigurationFailedValue = "UpdateConfigurationFailed";
        private const string ModelResetFailedValue = "ModelResetFailed";
        private const string ModelPublishFailedValue = "ModelPublishFailed";
        private const string ModelMetadataUpdateFailedValue = "ModelMetadataUpdateFailed";
        private const string OperationNotAllowedValue = "OperationNotAllowed";

        /// <summary> Request could not be understood by the server. </summary>
        public static PersonalizerErrorCode BadRequest { get; } = new PersonalizerErrorCode(BadRequestValue);
        /// <summary> Invalid service configuration. </summary>
        public static PersonalizerErrorCode InvalidServiceConfiguration { get; } = new PersonalizerErrorCode(InvalidServiceConfigurationValue);
        /// <summary> Updating defaultReward, rewardWaitTime and rewardAggregation when changing learning mode from Online to Apprentice mode and vice versa is not allowed. Make the mode change and then change the additional settings with an additional API call. </summary>
        public static PersonalizerErrorCode InvalidLearningModeServiceConfiguration { get; } = new PersonalizerErrorCode(InvalidLearningModeServiceConfigurationValue);
        /// <summary> Invalid policy configuration. </summary>
        public static PersonalizerErrorCode InvalidPolicyConfiguration { get; } = new PersonalizerErrorCode(InvalidPolicyConfigurationValue);
        /// <summary> Invalid policy contract. </summary>
        public static PersonalizerErrorCode InvalidPolicyContract { get; } = new PersonalizerErrorCode(InvalidPolicyContractValue);
        /// <summary> Invalid evaluation contract. </summary>
        public static PersonalizerErrorCode InvalidEvaluationContract { get; } = new PersonalizerErrorCode(InvalidEvaluationContractValue);
        /// <summary> Custom policy names should be unique. </summary>
        public static PersonalizerErrorCode DuplicateCustomPolicyNames { get; } = new PersonalizerErrorCode(DuplicateCustomPolicyNamesValue);
        /// <summary> No logs exist in date range. </summary>
        public static PersonalizerErrorCode NoLogsExistInDateRange { get; } = new PersonalizerErrorCode(NoLogsExistInDateRangeValue);
        /// <summary> Total size of logs exceed allowed limit. </summary>
        public static PersonalizerErrorCode LogsSizeExceedAllowedLimit { get; } = new PersonalizerErrorCode(LogsSizeExceedAllowedLimitValue);
        /// <summary> Invalid reward request. </summary>
        public static PersonalizerErrorCode InvalidRewardRequest { get; } = new PersonalizerErrorCode(InvalidRewardRequestValue);
        /// <summary> Invalid activate event request. </summary>
        public static PersonalizerErrorCode InvalidEventIdToActivate { get; } = new PersonalizerErrorCode(InvalidEventIdToActivateValue);
        /// <summary> Invalid request. </summary>
        public static PersonalizerErrorCode InvalidRankRequest { get; } = new PersonalizerErrorCode(InvalidRankRequestValue);
        /// <summary> Invalid request. </summary>
        public static PersonalizerErrorCode InvalidExportLogsRequest { get; } = new PersonalizerErrorCode(InvalidExportLogsRequestValue);
        /// <summary> Invalid request. </summary>
        public static PersonalizerErrorCode InvalidRequest { get; } = new PersonalizerErrorCode(InvalidRequestValue);
        /// <summary> SAS Uri must be the Uri to a container that has write permissions. </summary>
        public static PersonalizerErrorCode InvalidContainer { get; } = new PersonalizerErrorCode(InvalidContainerValue);
        /// <summary> Invalid model metadata. </summary>
        public static PersonalizerErrorCode InvalidModelMetadata { get; } = new PersonalizerErrorCode(InvalidModelMetadataValue);
        /// <summary> Apprentice mode never turned on. </summary>
        public static PersonalizerErrorCode ApprenticeModeNeverTurnedOn { get; } = new PersonalizerErrorCode(ApprenticeModeNeverTurnedOnValue);
        /// <summary> AppId is missing in the header. </summary>
        public static PersonalizerErrorCode MissingAppId { get; } = new PersonalizerErrorCode(MissingAppIdValue);
        /// <summary> Reward wait time should be either 10 minutes or 4 hours or 12 hours or 24 hours. </summary>
        public static PersonalizerErrorCode InvalidRewardWaitTime { get; } = new PersonalizerErrorCode(InvalidRewardWaitTimeValue);
        /// <summary> Log Retention Days must be -1 to store indefinitely or must be at least reward wait time plus 1 day (rounded up). </summary>
        public static PersonalizerErrorCode InvalidLogRetentionDays { get; } = new PersonalizerErrorCode(InvalidLogRetentionDaysValue);
        /// <summary> Multi-slot feature is currently disabled. Please follow multi-slot Personalizer documentation to update your loop settings to enable multi-slot functionality. </summary>
        public static PersonalizerErrorCode InvalidMultiSlotApiAccess { get; } = new PersonalizerErrorCode(InvalidMultiSlotApiAccessValue);
        /// <summary> Exceeds maximum allowed payload size. </summary>
        public static PersonalizerErrorCode PayloadSizeExceeded { get; } = new PersonalizerErrorCode(PayloadSizeExceededValue);
        /// <summary> Given model file is not signed or does not have a valid signature. </summary>
        public static PersonalizerErrorCode InvalidModelImportSignature { get; } = new PersonalizerErrorCode(InvalidModelImportSignatureValue);
        /// <summary> Given model file format is invalid. </summary>
        public static PersonalizerErrorCode InvalidModelImportFormat { get; } = new PersonalizerErrorCode(InvalidModelImportFormatValue);
        /// <summary> Api is currently disabled for the instance. </summary>
        public static PersonalizerErrorCode InvalidApiAccess { get; } = new PersonalizerErrorCode(InvalidApiAccessValue);
        /// <summary> Key vault Key used for customer managed key cannot be accessed. </summary>
        public static PersonalizerErrorCode ModelFileAccessDenied { get; } = new PersonalizerErrorCode(ModelFileAccessDeniedValue);
        /// <summary> Auto-optimization is not compatible with multi-slot personalization. </summary>
        public static PersonalizerErrorCode ProblemTypeIncompatibleWithAutoOptimization { get; } = new PersonalizerErrorCode(ProblemTypeIncompatibleWithAutoOptimizationValue);
        /// <summary> Requested resource does not exist on the server. </summary>
        public static PersonalizerErrorCode ResourceNotFound { get; } = new PersonalizerErrorCode(ResourceNotFoundValue);
        /// <summary> Front end not found. </summary>
        public static PersonalizerErrorCode FrontEndNotFound { get; } = new PersonalizerErrorCode(FrontEndNotFoundValue);
        /// <summary> Offline Evaluation not found. </summary>
        public static PersonalizerErrorCode EvaluationNotFound { get; } = new PersonalizerErrorCode(EvaluationNotFoundValue);
        /// <summary> Learning Settings not found in evaluation. </summary>
        public static PersonalizerErrorCode LearningSettingsNotFound { get; } = new PersonalizerErrorCode(LearningSettingsNotFoundValue);
        /// <summary> Model not found in evaluation. </summary>
        public static PersonalizerErrorCode EvaluationModelNotFound { get; } = new PersonalizerErrorCode(EvaluationModelNotFoundValue);
        /// <summary> Log properties not found. </summary>
        public static PersonalizerErrorCode LogsPropertiesNotFound { get; } = new PersonalizerErrorCode(LogsPropertiesNotFoundValue);
        /// <summary> Error while ranking actions using model. Please verify the learning settings are valid. </summary>
        public static PersonalizerErrorCode ModelRankingError { get; } = new PersonalizerErrorCode(ModelRankingErrorValue);
        /// <summary> A generic error has occurred on the server. </summary>
        public static PersonalizerErrorCode InternalServerError { get; } = new PersonalizerErrorCode(InternalServerErrorValue);
        /// <summary> Rank call returned null response. </summary>
        public static PersonalizerErrorCode RankNullResponse { get; } = new PersonalizerErrorCode(RankNullResponseValue);
        /// <summary> Failed to update configuration. </summary>
        public static PersonalizerErrorCode UpdateConfigurationFailed { get; } = new PersonalizerErrorCode(UpdateConfigurationFailedValue);
        /// <summary> Model reset failed. </summary>
        public static PersonalizerErrorCode ModelResetFailed { get; } = new PersonalizerErrorCode(ModelResetFailedValue);
        /// <summary> Model publish failed. </summary>
        public static PersonalizerErrorCode ModelPublishFailed { get; } = new PersonalizerErrorCode(ModelPublishFailedValue);
        /// <summary> Model metadata update failed. </summary>
        public static PersonalizerErrorCode ModelMetadataUpdateFailed { get; } = new PersonalizerErrorCode(ModelMetadataUpdateFailedValue);
        /// <summary> This operation is not allowed at this time. </summary>
        public static PersonalizerErrorCode OperationNotAllowed { get; } = new PersonalizerErrorCode(OperationNotAllowedValue);
        /// <summary> Determines if two <see cref="PersonalizerErrorCode"/> values are the same. </summary>
        public static bool operator ==(PersonalizerErrorCode left, PersonalizerErrorCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PersonalizerErrorCode"/> values are not the same. </summary>
        public static bool operator !=(PersonalizerErrorCode left, PersonalizerErrorCode right) => !left.Equals(right);
        /// <summary> Converts a string to a <see cref="PersonalizerErrorCode"/>. </summary>
        public static implicit operator PersonalizerErrorCode(string value) => new PersonalizerErrorCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PersonalizerErrorCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PersonalizerErrorCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value?.GetHashCode() ?? 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
