// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.AI.Personalizer.Models
{
    /// <summary> The error object. </summary>
    internal partial class PersonalizerError
    {
        /// <summary> Initializes a new instance of PersonalizerError. </summary>
        /// <param name="code"> Error Codes returned by Personalizer. </param>
        /// <param name="message"> A message explaining the error reported by the service. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="message"/> is null. </exception>
        internal PersonalizerError(PersonalizerErrorCode code, string message)
        {
            if (message == null)
            {
                throw new ArgumentNullException(nameof(message));
            }

            Code = code;
            Message = message;
            Details = new ChangeTrackingList<PersonalizerError>();
        }

        /// <summary> Initializes a new instance of PersonalizerError. </summary>
        /// <param name="code"> Error Codes returned by Personalizer. </param>
        /// <param name="message"> A message explaining the error reported by the service. </param>
        /// <param name="target"> Error source element. </param>
        /// <param name="details"> An array of details about specific errors that led to this reported error. </param>
        /// <param name="innerError"> An object containing more specific information than the parent object about the error. </param>
        internal PersonalizerError(PersonalizerErrorCode code, string message, string target, IReadOnlyList<PersonalizerError> details, InternalError innerError)
        {
            Code = code;
            Message = message;
            Target = target;
            Details = details;
            InnerError = innerError;
        }

        /// <summary> Error Codes returned by Personalizer. </summary>
        public PersonalizerErrorCode Code { get; }
        /// <summary> A message explaining the error reported by the service. </summary>
        public string Message { get; }
        /// <summary> Error source element. </summary>
        public string Target { get; }
        /// <summary> An array of details about specific errors that led to this reported error. </summary>
        public IReadOnlyList<PersonalizerError> Details { get; }
        /// <summary> An object containing more specific information than the parent object about the error. </summary>
        public InternalError InnerError { get; }
    }
}
