// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Personalizer.Models
{
    internal partial class PersonalizerError
    {
        internal static PersonalizerError DeserializePersonalizerError(JsonElement element)
        {
            PersonalizerErrorCode code = default;
            string message = default;
            string target = default;
            IReadOnlyList<PersonalizerError> details = default;
            InternalError innerError = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("code"))
                {
                    code = new PersonalizerErrorCode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("message"))
                {
                    message = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("target"))
                {
                    target = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("details"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    List<PersonalizerError> array = new List<PersonalizerError>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DeserializePersonalizerError(item));
                    }
                    details = array;
                    continue;
                }
                if (property.NameEquals("innerError"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    innerError = InternalError.DeserializeInternalError(property.Value);
                    continue;
                }
            }
            return new PersonalizerError(code, message, target, details ?? new ChangeTrackingList<PersonalizerError>(), innerError);
        }
    }
}
