// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Personalizer.Models
{
    internal partial class InternalError
    {
        internal static InternalError DeserializeInternalError(JsonElement element)
        {
            string code = default;
            InternalError innererror = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("code"))
                {
                    code = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("innererror"))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    innererror = DeserializeInternalError(property.Value);
                    continue;
                }
            }
            return new InternalError(code, innererror);
        }
    }
}
