// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.AI.Personalizer
{
    internal partial class EvaluationsRestClient
    {
        private string endpoint;
        private ClientDiagnostics _clientDiagnostics;
        private HttpPipeline _pipeline;

        /// <summary> Initializes a new instance of EvaluationsRestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> Supported Cognitive Services endpoint. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="endpoint"/> is null. </exception>
        public EvaluationsRestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, string endpoint)
        {
            this.endpoint = endpoint ?? throw new ArgumentNullException(nameof(endpoint));
            _clientDiagnostics = clientDiagnostics;
            _pipeline = pipeline;
        }

        internal HttpMessage CreateDeleteRequest(string evaluationId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(endpoint, false);
            uri.AppendRaw("/personalizer/v1.1-preview.3", false);
            uri.AppendPath("/evaluations/", false);
            uri.AppendPath(evaluationId, true);
            request.Uri = uri;
            return message;
        }

        /// <summary> Delete the Offline Evaluation associated with the Id. </summary>
        /// <param name="evaluationId"> Id of the Offline Evaluation to delete. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="evaluationId"/> is null. </exception>
        public async Task<Response> DeleteAsync(string evaluationId, CancellationToken cancellationToken = default)
        {
            if (evaluationId == null)
            {
                throw new ArgumentNullException(nameof(evaluationId));
            }

            using var message = CreateDeleteRequest(evaluationId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Delete the Offline Evaluation associated with the Id. </summary>
        /// <param name="evaluationId"> Id of the Offline Evaluation to delete. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="evaluationId"/> is null. </exception>
        public Response Delete(string evaluationId, CancellationToken cancellationToken = default)
        {
            if (evaluationId == null)
            {
                throw new ArgumentNullException(nameof(evaluationId));
            }

            using var message = CreateDeleteRequest(evaluationId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetRequest(string evaluationId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(endpoint, false);
            uri.AppendRaw("/personalizer/v1.1-preview.3", false);
            uri.AppendPath("/evaluations/", false);
            uri.AppendPath(evaluationId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get the Offline Evaluation associated with the Id. </summary>
        /// <param name="evaluationId"> Id of the Offline Evaluation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="evaluationId"/> is null. </exception>
        public async Task<Response<PersonalizerEvaluation>> GetAsync(string evaluationId, CancellationToken cancellationToken = default)
        {
            if (evaluationId == null)
            {
                throw new ArgumentNullException(nameof(evaluationId));
            }

            using var message = CreateGetRequest(evaluationId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PersonalizerEvaluation value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PersonalizerEvaluation.DeserializePersonalizerEvaluation(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get the Offline Evaluation associated with the Id. </summary>
        /// <param name="evaluationId"> Id of the Offline Evaluation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="evaluationId"/> is null. </exception>
        public Response<PersonalizerEvaluation> Get(string evaluationId, CancellationToken cancellationToken = default)
        {
            if (evaluationId == null)
            {
                throw new ArgumentNullException(nameof(evaluationId));
            }

            using var message = CreateGetRequest(evaluationId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PersonalizerEvaluation value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PersonalizerEvaluation.DeserializePersonalizerEvaluation(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListRequest()
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(endpoint, false);
            uri.AppendRaw("/personalizer/v1.1-preview.3", false);
            uri.AppendPath("/evaluations", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List of all Offline Evaluations. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<IReadOnlyList<PersonalizerEvaluation>>> ListAsync(CancellationToken cancellationToken = default)
        {
            using var message = CreateListRequest();
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IReadOnlyList<PersonalizerEvaluation> value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        List<PersonalizerEvaluation> array = new List<PersonalizerEvaluation>();
                        foreach (var item in document.RootElement.EnumerateArray())
                        {
                            array.Add(PersonalizerEvaluation.DeserializePersonalizerEvaluation(item));
                        }
                        value = array;
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List of all Offline Evaluations. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<IReadOnlyList<PersonalizerEvaluation>> List(CancellationToken cancellationToken = default)
        {
            using var message = CreateListRequest();
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IReadOnlyList<PersonalizerEvaluation> value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        List<PersonalizerEvaluation> array = new List<PersonalizerEvaluation>();
                        foreach (var item in document.RootElement.EnumerateArray())
                        {
                            array.Add(PersonalizerEvaluation.DeserializePersonalizerEvaluation(item));
                        }
                        value = array;
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateCreateRequest(PersonalizerEvaluationOptions evaluation)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(endpoint, false);
            uri.AppendRaw("/personalizer/v1.1-preview.3", false);
            uri.AppendPath("/evaluations", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(evaluation);
            request.Content = content;
            return message;
        }

        /// <summary> Submit a new Offline Evaluation job. </summary>
        /// <param name="evaluation"> The Offline Evaluation job definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="evaluation"/> is null. </exception>
        public async Task<ResponseWithHeaders<PersonalizerEvaluation, EvaluationsCreateHeaders>> CreateAsync(PersonalizerEvaluationOptions evaluation, CancellationToken cancellationToken = default)
        {
            if (evaluation == null)
            {
                throw new ArgumentNullException(nameof(evaluation));
            }

            using var message = CreateCreateRequest(evaluation);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new EvaluationsCreateHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    {
                        PersonalizerEvaluation value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PersonalizerEvaluation.DeserializePersonalizerEvaluation(document.RootElement);
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Submit a new Offline Evaluation job. </summary>
        /// <param name="evaluation"> The Offline Evaluation job definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="evaluation"/> is null. </exception>
        public ResponseWithHeaders<PersonalizerEvaluation, EvaluationsCreateHeaders> Create(PersonalizerEvaluationOptions evaluation, CancellationToken cancellationToken = default)
        {
            if (evaluation == null)
            {
                throw new ArgumentNullException(nameof(evaluation));
            }

            using var message = CreateCreateRequest(evaluation);
            _pipeline.Send(message, cancellationToken);
            var headers = new EvaluationsCreateHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 201:
                    {
                        PersonalizerEvaluation value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PersonalizerEvaluation.DeserializePersonalizerEvaluation(document.RootElement);
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
