// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Peering.Models;

namespace Azure.ResourceManager.Peering
{
    internal partial class LookingGlassRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of LookingGlassRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public LookingGlassRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2022-10-01";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateInvokeRequestUri(string subscriptionId, LookingGlassCommand command, LookingGlassSourceType sourceType, string sourceLocation, string destinationIP)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Peering/lookingGlass", false);
            uri.AppendQuery("command", command.ToString(), true);
            uri.AppendQuery("sourceType", sourceType.ToString(), true);
            uri.AppendQuery("sourceLocation", sourceLocation, true);
            uri.AppendQuery("destinationIP", destinationIP, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateInvokeRequest(string subscriptionId, LookingGlassCommand command, LookingGlassSourceType sourceType, string sourceLocation, string destinationIP)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Peering/lookingGlass", false);
            uri.AppendQuery("command", command.ToString(), true);
            uri.AppendQuery("sourceType", sourceType.ToString(), true);
            uri.AppendQuery("sourceLocation", sourceLocation, true);
            uri.AppendQuery("destinationIP", destinationIP, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Run looking glass functionality. </summary>
        /// <param name="subscriptionId"> The Azure subscription ID. </param>
        /// <param name="command"> The command to be executed: ping, traceroute, bgpRoute. </param>
        /// <param name="sourceType"> The type of the source: Edge site or Azure Region. </param>
        /// <param name="sourceLocation"> The location of the source. </param>
        /// <param name="destinationIP"> The IP address of the destination. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="sourceLocation"/> or <paramref name="destinationIP"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<LookingGlassOutput>> InvokeAsync(string subscriptionId, LookingGlassCommand command, LookingGlassSourceType sourceType, string sourceLocation, string destinationIP, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNull(sourceLocation, nameof(sourceLocation));
            Argument.AssertNotNull(destinationIP, nameof(destinationIP));

            using var message = CreateInvokeRequest(subscriptionId, command, sourceType, sourceLocation, destinationIP);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LookingGlassOutput value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = LookingGlassOutput.DeserializeLookingGlassOutput(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Run looking glass functionality. </summary>
        /// <param name="subscriptionId"> The Azure subscription ID. </param>
        /// <param name="command"> The command to be executed: ping, traceroute, bgpRoute. </param>
        /// <param name="sourceType"> The type of the source: Edge site or Azure Region. </param>
        /// <param name="sourceLocation"> The location of the source. </param>
        /// <param name="destinationIP"> The IP address of the destination. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="sourceLocation"/> or <paramref name="destinationIP"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<LookingGlassOutput> Invoke(string subscriptionId, LookingGlassCommand command, LookingGlassSourceType sourceType, string sourceLocation, string destinationIP, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNull(sourceLocation, nameof(sourceLocation));
            Argument.AssertNotNull(destinationIP, nameof(destinationIP));

            using var message = CreateInvokeRequest(subscriptionId, command, sourceType, sourceLocation, destinationIP);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LookingGlassOutput value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = LookingGlassOutput.DeserializeLookingGlassOutput(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
