// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Peering.Models;

namespace Azure.ResourceManager.Peering
{
    internal partial class LegacyPeeringsRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of LegacyPeeringsRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public LegacyPeeringsRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2022-10-01";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateListRequestUri(string subscriptionId, string peeringLocation, LegacyPeeringsKind kind, int? asn, DirectPeeringType? directPeeringType)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Peering/legacyPeerings", false);
            uri.AppendQuery("peeringLocation", peeringLocation, true);
            uri.AppendQuery("kind", kind.ToString(), true);
            if (asn != null)
            {
                uri.AppendQuery("asn", asn.Value, true);
            }
            if (directPeeringType != null)
            {
                uri.AppendQuery("directPeeringType", directPeeringType.Value.ToString(), true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateListRequest(string subscriptionId, string peeringLocation, LegacyPeeringsKind kind, int? asn, DirectPeeringType? directPeeringType)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Peering/legacyPeerings", false);
            uri.AppendQuery("peeringLocation", peeringLocation, true);
            uri.AppendQuery("kind", kind.ToString(), true);
            if (asn != null)
            {
                uri.AppendQuery("asn", asn.Value, true);
            }
            if (directPeeringType != null)
            {
                uri.AppendQuery("directPeeringType", directPeeringType.Value.ToString(), true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Lists all of the legacy peerings under the given subscription matching the specified kind and location. </summary>
        /// <param name="subscriptionId"> The Azure subscription ID. </param>
        /// <param name="peeringLocation"> The location of the peering. </param>
        /// <param name="kind"> The kind of the peering. </param>
        /// <param name="asn"> The ASN number associated with a legacy peering. </param>
        /// <param name="directPeeringType"> The direct peering type. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="peeringLocation"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PeeringListResult>> ListAsync(string subscriptionId, string peeringLocation, LegacyPeeringsKind kind, int? asn = null, DirectPeeringType? directPeeringType = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNull(peeringLocation, nameof(peeringLocation));

            using var message = CreateListRequest(subscriptionId, peeringLocation, kind, asn, directPeeringType);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PeeringListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PeeringListResult.DeserializePeeringListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Lists all of the legacy peerings under the given subscription matching the specified kind and location. </summary>
        /// <param name="subscriptionId"> The Azure subscription ID. </param>
        /// <param name="peeringLocation"> The location of the peering. </param>
        /// <param name="kind"> The kind of the peering. </param>
        /// <param name="asn"> The ASN number associated with a legacy peering. </param>
        /// <param name="directPeeringType"> The direct peering type. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="peeringLocation"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PeeringListResult> List(string subscriptionId, string peeringLocation, LegacyPeeringsKind kind, int? asn = null, DirectPeeringType? directPeeringType = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNull(peeringLocation, nameof(peeringLocation));

            using var message = CreateListRequest(subscriptionId, peeringLocation, kind, asn, directPeeringType);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PeeringListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PeeringListResult.DeserializePeeringListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListNextPageRequestUri(string nextLink, string subscriptionId, string peeringLocation, LegacyPeeringsKind kind, int? asn, DirectPeeringType? directPeeringType)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListNextPageRequest(string nextLink, string subscriptionId, string peeringLocation, LegacyPeeringsKind kind, int? asn, DirectPeeringType? directPeeringType)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Lists all of the legacy peerings under the given subscription matching the specified kind and location. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> The Azure subscription ID. </param>
        /// <param name="peeringLocation"> The location of the peering. </param>
        /// <param name="kind"> The kind of the peering. </param>
        /// <param name="asn"> The ASN number associated with a legacy peering. </param>
        /// <param name="directPeeringType"> The direct peering type. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/> or <paramref name="peeringLocation"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PeeringListResult>> ListNextPageAsync(string nextLink, string subscriptionId, string peeringLocation, LegacyPeeringsKind kind, int? asn = null, DirectPeeringType? directPeeringType = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNull(peeringLocation, nameof(peeringLocation));

            using var message = CreateListNextPageRequest(nextLink, subscriptionId, peeringLocation, kind, asn, directPeeringType);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PeeringListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PeeringListResult.DeserializePeeringListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Lists all of the legacy peerings under the given subscription matching the specified kind and location. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> The Azure subscription ID. </param>
        /// <param name="peeringLocation"> The location of the peering. </param>
        /// <param name="kind"> The kind of the peering. </param>
        /// <param name="asn"> The ASN number associated with a legacy peering. </param>
        /// <param name="directPeeringType"> The direct peering type. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/> or <paramref name="peeringLocation"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PeeringListResult> ListNextPage(string nextLink, string subscriptionId, string peeringLocation, LegacyPeeringsKind kind, int? asn = null, DirectPeeringType? directPeeringType = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNull(peeringLocation, nameof(peeringLocation));

            using var message = CreateListNextPageRequest(nextLink, subscriptionId, peeringLocation, kind, asn, directPeeringType);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PeeringListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PeeringListResult.DeserializePeeringListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
