// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The Routing Preference unbilled prefix. </summary>
    public partial class RoutingPreferenceUnbilledPrefix
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RoutingPreferenceUnbilledPrefix"/>. </summary>
        internal RoutingPreferenceUnbilledPrefix()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RoutingPreferenceUnbilledPrefix"/>. </summary>
        /// <param name="prefix"> The prefix. </param>
        /// <param name="azureRegion"> The Azure region. </param>
        /// <param name="peerAsn"> The peer ASN. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RoutingPreferenceUnbilledPrefix(string prefix, AzureLocation? azureRegion, int? peerAsn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Prefix = prefix;
            AzureRegion = azureRegion;
            PeerAsn = peerAsn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The prefix. </summary>
        public string Prefix { get; }
        /// <summary> The Azure region. </summary>
        public AzureLocation? AzureRegion { get; }
        /// <summary> The peer ASN. </summary>
        public int? PeerAsn { get; }
    }
}
