// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The state of the IPv6 session. </summary>
    public readonly partial struct PeeringSessionStateV6 : IEquatable<PeeringSessionStateV6>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PeeringSessionStateV6"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PeeringSessionStateV6(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string IdleValue = "Idle";
        private const string ConnectValue = "Connect";
        private const string ActiveValue = "Active";
        private const string OpenSentValue = "OpenSent";
        private const string OpenConfirmValue = "OpenConfirm";
        private const string OpenReceivedValue = "OpenReceived";
        private const string EstablishedValue = "Established";
        private const string PendingAddValue = "PendingAdd";
        private const string PendingUpdateValue = "PendingUpdate";
        private const string PendingRemoveValue = "PendingRemove";

        /// <summary> None. </summary>
        public static PeeringSessionStateV6 None { get; } = new PeeringSessionStateV6(NoneValue);
        /// <summary> Idle. </summary>
        public static PeeringSessionStateV6 Idle { get; } = new PeeringSessionStateV6(IdleValue);
        /// <summary> Connect. </summary>
        public static PeeringSessionStateV6 Connect { get; } = new PeeringSessionStateV6(ConnectValue);
        /// <summary> Active. </summary>
        public static PeeringSessionStateV6 Active { get; } = new PeeringSessionStateV6(ActiveValue);
        /// <summary> OpenSent. </summary>
        public static PeeringSessionStateV6 OpenSent { get; } = new PeeringSessionStateV6(OpenSentValue);
        /// <summary> OpenConfirm. </summary>
        public static PeeringSessionStateV6 OpenConfirm { get; } = new PeeringSessionStateV6(OpenConfirmValue);
        /// <summary> OpenReceived. </summary>
        public static PeeringSessionStateV6 OpenReceived { get; } = new PeeringSessionStateV6(OpenReceivedValue);
        /// <summary> Established. </summary>
        public static PeeringSessionStateV6 Established { get; } = new PeeringSessionStateV6(EstablishedValue);
        /// <summary> PendingAdd. </summary>
        public static PeeringSessionStateV6 PendingAdd { get; } = new PeeringSessionStateV6(PendingAddValue);
        /// <summary> PendingUpdate. </summary>
        public static PeeringSessionStateV6 PendingUpdate { get; } = new PeeringSessionStateV6(PendingUpdateValue);
        /// <summary> PendingRemove. </summary>
        public static PeeringSessionStateV6 PendingRemove { get; } = new PeeringSessionStateV6(PendingRemoveValue);
        /// <summary> Determines if two <see cref="PeeringSessionStateV6"/> values are the same. </summary>
        public static bool operator ==(PeeringSessionStateV6 left, PeeringSessionStateV6 right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PeeringSessionStateV6"/> values are not the same. </summary>
        public static bool operator !=(PeeringSessionStateV6 left, PeeringSessionStateV6 right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PeeringSessionStateV6"/>. </summary>
        public static implicit operator PeeringSessionStateV6(string value) => new PeeringSessionStateV6(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PeeringSessionStateV6 other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PeeringSessionStateV6 other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
