// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The state of the IPv4 session. </summary>
    public readonly partial struct PeeringSessionStateV4 : IEquatable<PeeringSessionStateV4>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PeeringSessionStateV4"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PeeringSessionStateV4(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string IdleValue = "Idle";
        private const string ConnectValue = "Connect";
        private const string ActiveValue = "Active";
        private const string OpenSentValue = "OpenSent";
        private const string OpenConfirmValue = "OpenConfirm";
        private const string OpenReceivedValue = "OpenReceived";
        private const string EstablishedValue = "Established";
        private const string PendingAddValue = "PendingAdd";
        private const string PendingUpdateValue = "PendingUpdate";
        private const string PendingRemoveValue = "PendingRemove";

        /// <summary> None. </summary>
        public static PeeringSessionStateV4 None { get; } = new PeeringSessionStateV4(NoneValue);
        /// <summary> Idle. </summary>
        public static PeeringSessionStateV4 Idle { get; } = new PeeringSessionStateV4(IdleValue);
        /// <summary> Connect. </summary>
        public static PeeringSessionStateV4 Connect { get; } = new PeeringSessionStateV4(ConnectValue);
        /// <summary> Active. </summary>
        public static PeeringSessionStateV4 Active { get; } = new PeeringSessionStateV4(ActiveValue);
        /// <summary> OpenSent. </summary>
        public static PeeringSessionStateV4 OpenSent { get; } = new PeeringSessionStateV4(OpenSentValue);
        /// <summary> OpenConfirm. </summary>
        public static PeeringSessionStateV4 OpenConfirm { get; } = new PeeringSessionStateV4(OpenConfirmValue);
        /// <summary> OpenReceived. </summary>
        public static PeeringSessionStateV4 OpenReceived { get; } = new PeeringSessionStateV4(OpenReceivedValue);
        /// <summary> Established. </summary>
        public static PeeringSessionStateV4 Established { get; } = new PeeringSessionStateV4(EstablishedValue);
        /// <summary> PendingAdd. </summary>
        public static PeeringSessionStateV4 PendingAdd { get; } = new PeeringSessionStateV4(PendingAddValue);
        /// <summary> PendingUpdate. </summary>
        public static PeeringSessionStateV4 PendingUpdate { get; } = new PeeringSessionStateV4(PendingUpdateValue);
        /// <summary> PendingRemove. </summary>
        public static PeeringSessionStateV4 PendingRemove { get; } = new PeeringSessionStateV4(PendingRemoveValue);
        /// <summary> Determines if two <see cref="PeeringSessionStateV4"/> values are the same. </summary>
        public static bool operator ==(PeeringSessionStateV4 left, PeeringSessionStateV4 right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PeeringSessionStateV4"/> values are not the same. </summary>
        public static bool operator !=(PeeringSessionStateV4 left, PeeringSessionStateV4 right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PeeringSessionStateV4"/>. </summary>
        public static implicit operator PeeringSessionStateV4(string value) => new PeeringSessionStateV4(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PeeringSessionStateV4 other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PeeringSessionStateV4 other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
