// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The field indicating if Microsoft provides session ip addresses. </summary>
    public readonly partial struct PeeringSessionAddressProvider : IEquatable<PeeringSessionAddressProvider>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PeeringSessionAddressProvider"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PeeringSessionAddressProvider(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftValue = "Microsoft";
        private const string PeerValue = "Peer";

        /// <summary> Microsoft. </summary>
        public static PeeringSessionAddressProvider Microsoft { get; } = new PeeringSessionAddressProvider(MicrosoftValue);
        /// <summary> Peer. </summary>
        public static PeeringSessionAddressProvider Peer { get; } = new PeeringSessionAddressProvider(PeerValue);
        /// <summary> Determines if two <see cref="PeeringSessionAddressProvider"/> values are the same. </summary>
        public static bool operator ==(PeeringSessionAddressProvider left, PeeringSessionAddressProvider right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PeeringSessionAddressProvider"/> values are not the same. </summary>
        public static bool operator !=(PeeringSessionAddressProvider left, PeeringSessionAddressProvider right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PeeringSessionAddressProvider"/>. </summary>
        public static implicit operator PeeringSessionAddressProvider(string value) => new PeeringSessionAddressProvider(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PeeringSessionAddressProvider other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PeeringSessionAddressProvider other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
