// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The PeeringServiceProviderAvailability. </summary>
    public readonly partial struct PeeringServiceProviderAvailability : IEquatable<PeeringServiceProviderAvailability>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PeeringServiceProviderAvailability"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PeeringServiceProviderAvailability(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AvailableValue = "Available";
        private const string UnavailableValue = "Unavailable";

        /// <summary> Available. </summary>
        public static PeeringServiceProviderAvailability Available { get; } = new PeeringServiceProviderAvailability(AvailableValue);
        /// <summary> Unavailable. </summary>
        public static PeeringServiceProviderAvailability Unavailable { get; } = new PeeringServiceProviderAvailability(UnavailableValue);
        /// <summary> Determines if two <see cref="PeeringServiceProviderAvailability"/> values are the same. </summary>
        public static bool operator ==(PeeringServiceProviderAvailability left, PeeringServiceProviderAvailability right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PeeringServiceProviderAvailability"/> values are not the same. </summary>
        public static bool operator !=(PeeringServiceProviderAvailability left, PeeringServiceProviderAvailability right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PeeringServiceProviderAvailability"/>. </summary>
        public static implicit operator PeeringServiceProviderAvailability(string value) => new PeeringServiceProviderAvailability(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PeeringServiceProviderAvailability other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PeeringServiceProviderAvailability other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
