// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Peering.Models
{
    public partial class PeeringServicePrefixEvent : IUtf8JsonSerializable, IJsonModel<PeeringServicePrefixEvent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PeeringServicePrefixEvent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PeeringServicePrefixEvent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PeeringServicePrefixEvent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PeeringServicePrefixEvent)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(EventTimestamp))
            {
                writer.WritePropertyName("eventTimestamp"u8);
                writer.WriteStringValue(EventTimestamp.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(EventType))
            {
                writer.WritePropertyName("eventType"u8);
                writer.WriteStringValue(EventType);
            }
            if (options.Format != "W" && Optional.IsDefined(EventSummary))
            {
                writer.WritePropertyName("eventSummary"u8);
                writer.WriteStringValue(EventSummary);
            }
            if (options.Format != "W" && Optional.IsDefined(EventLevel))
            {
                writer.WritePropertyName("eventLevel"u8);
                writer.WriteStringValue(EventLevel);
            }
            if (options.Format != "W" && Optional.IsDefined(EventDescription))
            {
                writer.WritePropertyName("eventDescription"u8);
                writer.WriteStringValue(EventDescription);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PeeringServicePrefixEvent IJsonModel<PeeringServicePrefixEvent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PeeringServicePrefixEvent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PeeringServicePrefixEvent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePeeringServicePrefixEvent(document.RootElement, options);
        }

        internal static PeeringServicePrefixEvent DeserializePeeringServicePrefixEvent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DateTimeOffset? eventTimestamp = default;
            string eventType = default;
            string eventSummary = default;
            string eventLevel = default;
            string eventDescription = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("eventTimestamp"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    eventTimestamp = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("eventType"u8))
                {
                    eventType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("eventSummary"u8))
                {
                    eventSummary = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("eventLevel"u8))
                {
                    eventLevel = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("eventDescription"u8))
                {
                    eventDescription = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PeeringServicePrefixEvent(
                eventTimestamp,
                eventType,
                eventSummary,
                eventLevel,
                eventDescription,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<PeeringServicePrefixEvent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PeeringServicePrefixEvent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PeeringServicePrefixEvent)} does not support writing '{options.Format}' format.");
            }
        }

        PeeringServicePrefixEvent IPersistableModel<PeeringServicePrefixEvent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PeeringServicePrefixEvent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePeeringServicePrefixEvent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PeeringServicePrefixEvent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PeeringServicePrefixEvent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
