// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The role of the contact. </summary>
    public readonly partial struct PeeringRole : IEquatable<PeeringRole>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PeeringRole"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PeeringRole(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NocValue = "Noc";
        private const string PolicyValue = "Policy";
        private const string TechnicalValue = "Technical";
        private const string ServiceValue = "Service";
        private const string EscalationValue = "Escalation";
        private const string OtherValue = "Other";

        /// <summary> Noc. </summary>
        public static PeeringRole Noc { get; } = new PeeringRole(NocValue);
        /// <summary> Policy. </summary>
        public static PeeringRole Policy { get; } = new PeeringRole(PolicyValue);
        /// <summary> Technical. </summary>
        public static PeeringRole Technical { get; } = new PeeringRole(TechnicalValue);
        /// <summary> Service. </summary>
        public static PeeringRole Service { get; } = new PeeringRole(ServiceValue);
        /// <summary> Escalation. </summary>
        public static PeeringRole Escalation { get; } = new PeeringRole(EscalationValue);
        /// <summary> Other. </summary>
        public static PeeringRole Other { get; } = new PeeringRole(OtherValue);
        /// <summary> Determines if two <see cref="PeeringRole"/> values are the same. </summary>
        public static bool operator ==(PeeringRole left, PeeringRole right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PeeringRole"/> values are not the same. </summary>
        public static bool operator !=(PeeringRole left, PeeringRole right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PeeringRole"/>. </summary>
        public static implicit operator PeeringRole(string value) => new PeeringRole(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PeeringRole other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PeeringRole other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
