// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The properties that define a received route. </summary>
    public partial class PeeringReceivedRoute
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PeeringReceivedRoute"/>. </summary>
        internal PeeringReceivedRoute()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PeeringReceivedRoute"/>. </summary>
        /// <param name="prefix"> The prefix. </param>
        /// <param name="nextHop"> The next hop for the prefix. </param>
        /// <param name="asPath"> The AS path for the prefix. </param>
        /// <param name="originAsValidationState"> The origin AS change information for the prefix. </param>
        /// <param name="rpkiValidationState"> The RPKI validation state for the prefix and origin AS that's listed in the AS path. </param>
        /// <param name="trustAnchor"> The authority which holds the Route Origin Authorization record for the prefix, if any. </param>
        /// <param name="receivedTimestamp"> The received timestamp associated with the prefix. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PeeringReceivedRoute(string prefix, string nextHop, string asPath, string originAsValidationState, string rpkiValidationState, string trustAnchor, string receivedTimestamp, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Prefix = prefix;
            NextHop = nextHop;
            AsPath = asPath;
            OriginAsValidationState = originAsValidationState;
            RpkiValidationState = rpkiValidationState;
            TrustAnchor = trustAnchor;
            ReceivedTimestamp = receivedTimestamp;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The prefix. </summary>
        public string Prefix { get; }
        /// <summary> The next hop for the prefix. </summary>
        public string NextHop { get; }
        /// <summary> The AS path for the prefix. </summary>
        public string AsPath { get; }
        /// <summary> The origin AS change information for the prefix. </summary>
        public string OriginAsValidationState { get; }
        /// <summary> The RPKI validation state for the prefix and origin AS that's listed in the AS path. </summary>
        public string RpkiValidationState { get; }
        /// <summary> The authority which holds the Route Origin Authorization record for the prefix, if any. </summary>
        public string TrustAnchor { get; }
        /// <summary> The received timestamp associated with the prefix. </summary>
        public string ReceivedTimestamp { get; }
    }
}
