// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The PeeringLocationsKind. </summary>
    public readonly partial struct PeeringLocationsKind : IEquatable<PeeringLocationsKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PeeringLocationsKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PeeringLocationsKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DirectValue = "Direct";
        private const string ExchangeValue = "Exchange";

        /// <summary> Direct. </summary>
        public static PeeringLocationsKind Direct { get; } = new PeeringLocationsKind(DirectValue);
        /// <summary> Exchange. </summary>
        public static PeeringLocationsKind Exchange { get; } = new PeeringLocationsKind(ExchangeValue);
        /// <summary> Determines if two <see cref="PeeringLocationsKind"/> values are the same. </summary>
        public static bool operator ==(PeeringLocationsKind left, PeeringLocationsKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PeeringLocationsKind"/> values are not the same. </summary>
        public static bool operator !=(PeeringLocationsKind left, PeeringLocationsKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PeeringLocationsKind"/>. </summary>
        public static implicit operator PeeringLocationsKind(string value) => new PeeringLocationsKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PeeringLocationsKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PeeringLocationsKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
