// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The PeeringLocationsDirectPeeringType. </summary>
    public readonly partial struct PeeringLocationsDirectPeeringType : IEquatable<PeeringLocationsDirectPeeringType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PeeringLocationsDirectPeeringType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PeeringLocationsDirectPeeringType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EdgeValue = "Edge";
        private const string TransitValue = "Transit";
        private const string CdnValue = "Cdn";
        private const string InternalValue = "Internal";
        private const string IxValue = "Ix";
        private const string IxRsValue = "IxRs";
        private const string VoiceValue = "Voice";
        private const string EdgeZoneForOperatorsValue = "EdgeZoneForOperators";

        /// <summary> Edge. </summary>
        public static PeeringLocationsDirectPeeringType Edge { get; } = new PeeringLocationsDirectPeeringType(EdgeValue);
        /// <summary> Transit. </summary>
        public static PeeringLocationsDirectPeeringType Transit { get; } = new PeeringLocationsDirectPeeringType(TransitValue);
        /// <summary> Cdn. </summary>
        public static PeeringLocationsDirectPeeringType Cdn { get; } = new PeeringLocationsDirectPeeringType(CdnValue);
        /// <summary> Internal. </summary>
        public static PeeringLocationsDirectPeeringType Internal { get; } = new PeeringLocationsDirectPeeringType(InternalValue);
        /// <summary> Ix. </summary>
        public static PeeringLocationsDirectPeeringType Ix { get; } = new PeeringLocationsDirectPeeringType(IxValue);
        /// <summary> IxRs. </summary>
        public static PeeringLocationsDirectPeeringType IxRs { get; } = new PeeringLocationsDirectPeeringType(IxRsValue);
        /// <summary> Voice. </summary>
        public static PeeringLocationsDirectPeeringType Voice { get; } = new PeeringLocationsDirectPeeringType(VoiceValue);
        /// <summary> EdgeZoneForOperators. </summary>
        public static PeeringLocationsDirectPeeringType EdgeZoneForOperators { get; } = new PeeringLocationsDirectPeeringType(EdgeZoneForOperatorsValue);
        /// <summary> Determines if two <see cref="PeeringLocationsDirectPeeringType"/> values are the same. </summary>
        public static bool operator ==(PeeringLocationsDirectPeeringType left, PeeringLocationsDirectPeeringType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PeeringLocationsDirectPeeringType"/> values are not the same. </summary>
        public static bool operator !=(PeeringLocationsDirectPeeringType left, PeeringLocationsDirectPeeringType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PeeringLocationsDirectPeeringType"/>. </summary>
        public static implicit operator PeeringLocationsDirectPeeringType(string value) => new PeeringLocationsDirectPeeringType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PeeringLocationsDirectPeeringType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PeeringLocationsDirectPeeringType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
