// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The kind of the peering. </summary>
    public readonly partial struct PeeringKind : IEquatable<PeeringKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PeeringKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PeeringKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DirectValue = "Direct";
        private const string ExchangeValue = "Exchange";

        /// <summary> Direct. </summary>
        public static PeeringKind Direct { get; } = new PeeringKind(DirectValue);
        /// <summary> Exchange. </summary>
        public static PeeringKind Exchange { get; } = new PeeringKind(ExchangeValue);
        /// <summary> Determines if two <see cref="PeeringKind"/> values are the same. </summary>
        public static bool operator ==(PeeringKind left, PeeringKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PeeringKind"/> values are not the same. </summary>
        public static bool operator !=(PeeringKind left, PeeringKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PeeringKind"/>. </summary>
        public static implicit operator PeeringKind(string value) => new PeeringKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PeeringKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PeeringKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
