// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The family of the peering SKU. </summary>
    public readonly partial struct PeeringFamily : IEquatable<PeeringFamily>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PeeringFamily"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PeeringFamily(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DirectValue = "Direct";
        private const string ExchangeValue = "Exchange";

        /// <summary> Direct. </summary>
        public static PeeringFamily Direct { get; } = new PeeringFamily(DirectValue);
        /// <summary> Exchange. </summary>
        public static PeeringFamily Exchange { get; } = new PeeringFamily(ExchangeValue);
        /// <summary> Determines if two <see cref="PeeringFamily"/> values are the same. </summary>
        public static bool operator ==(PeeringFamily left, PeeringFamily right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PeeringFamily"/> values are not the same. </summary>
        public static bool operator !=(PeeringFamily left, PeeringFamily right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PeeringFamily"/>. </summary>
        public static implicit operator PeeringFamily(string value) => new PeeringFamily(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PeeringFamily other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PeeringFamily other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
