// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The properties that define an exchange connection. </summary>
    public partial class PeeringExchangeConnection
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PeeringExchangeConnection"/>. </summary>
        public PeeringExchangeConnection()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PeeringExchangeConnection"/>. </summary>
        /// <param name="peeringDBFacilityId"> The PeeringDB.com ID of the facility at which the connection has to be set up. </param>
        /// <param name="connectionState"> The state of the connection. </param>
        /// <param name="bgpSession"> The BGP session associated with the connection. </param>
        /// <param name="connectionIdentifier"> The unique identifier (GUID) for the connection. </param>
        /// <param name="errorMessage"> The error message related to the connection state, if any. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PeeringExchangeConnection(int? peeringDBFacilityId, PeeringConnectionState? connectionState, PeeringBgpSession bgpSession, Guid? connectionIdentifier, string errorMessage, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PeeringDBFacilityId = peeringDBFacilityId;
            ConnectionState = connectionState;
            BgpSession = bgpSession;
            ConnectionIdentifier = connectionIdentifier;
            ErrorMessage = errorMessage;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The PeeringDB.com ID of the facility at which the connection has to be set up. </summary>
        public int? PeeringDBFacilityId { get; set; }
        /// <summary> The state of the connection. </summary>
        public PeeringConnectionState? ConnectionState { get; }
        /// <summary> The BGP session associated with the connection. </summary>
        public PeeringBgpSession BgpSession { get; set; }
        /// <summary> The unique identifier (GUID) for the connection. </summary>
        public Guid? ConnectionIdentifier { get; set; }
        /// <summary> The error message related to the connection state, if any. </summary>
        public string ErrorMessage { get; }
    }
}
