// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The properties that define a direct connection. </summary>
    public partial class PeeringDirectConnection
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PeeringDirectConnection"/>. </summary>
        public PeeringDirectConnection()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PeeringDirectConnection"/>. </summary>
        /// <param name="bandwidthInMbps"> The bandwidth of the connection. </param>
        /// <param name="provisionedBandwidthInMbps"> The bandwidth that is actually provisioned. </param>
        /// <param name="sessionAddressProvider"> The field indicating if Microsoft provides session ip addresses. </param>
        /// <param name="useForPeeringService"> The flag that indicates whether or not the connection is used for peering service. </param>
        /// <param name="microsoftTrackingId"> The ID used within Microsoft's peering provisioning system to track the connection. </param>
        /// <param name="peeringDBFacilityId"> The PeeringDB.com ID of the facility at which the connection has to be set up. </param>
        /// <param name="connectionState"> The state of the connection. </param>
        /// <param name="bgpSession"> The BGP session associated with the connection. </param>
        /// <param name="connectionIdentifier"> The unique identifier (GUID) for the connection. </param>
        /// <param name="errorMessage"> The error message related to the connection state, if any. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PeeringDirectConnection(int? bandwidthInMbps, int? provisionedBandwidthInMbps, PeeringSessionAddressProvider? sessionAddressProvider, bool? useForPeeringService, string microsoftTrackingId, int? peeringDBFacilityId, PeeringConnectionState? connectionState, PeeringBgpSession bgpSession, string connectionIdentifier, string errorMessage, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BandwidthInMbps = bandwidthInMbps;
            ProvisionedBandwidthInMbps = provisionedBandwidthInMbps;
            SessionAddressProvider = sessionAddressProvider;
            UseForPeeringService = useForPeeringService;
            MicrosoftTrackingId = microsoftTrackingId;
            PeeringDBFacilityId = peeringDBFacilityId;
            ConnectionState = connectionState;
            BgpSession = bgpSession;
            ConnectionIdentifier = connectionIdentifier;
            ErrorMessage = errorMessage;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The bandwidth of the connection. </summary>
        public int? BandwidthInMbps { get; set; }
        /// <summary> The bandwidth that is actually provisioned. </summary>
        public int? ProvisionedBandwidthInMbps { get; }
        /// <summary> The field indicating if Microsoft provides session ip addresses. </summary>
        public PeeringSessionAddressProvider? SessionAddressProvider { get; set; }
        /// <summary> The flag that indicates whether or not the connection is used for peering service. </summary>
        public bool? UseForPeeringService { get; set; }
        /// <summary> The ID used within Microsoft's peering provisioning system to track the connection. </summary>
        public string MicrosoftTrackingId { get; }
        /// <summary> The PeeringDB.com ID of the facility at which the connection has to be set up. </summary>
        public int? PeeringDBFacilityId { get; set; }
        /// <summary> The state of the connection. </summary>
        public PeeringConnectionState? ConnectionState { get; }
        /// <summary> The BGP session associated with the connection. </summary>
        public PeeringBgpSession BgpSession { get; set; }
        /// <summary> The unique identifier (GUID) for the connection. </summary>
        public string ConnectionIdentifier { get; set; }
        /// <summary> The error message related to the connection state, if any. </summary>
        public string ErrorMessage { get; }
    }
}
