// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Peering.Models
{
    public partial class PeeringDirectConnection : IUtf8JsonSerializable, IJsonModel<PeeringDirectConnection>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PeeringDirectConnection>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PeeringDirectConnection>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PeeringDirectConnection>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PeeringDirectConnection)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(BandwidthInMbps))
            {
                writer.WritePropertyName("bandwidthInMbps"u8);
                writer.WriteNumberValue(BandwidthInMbps.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisionedBandwidthInMbps))
            {
                writer.WritePropertyName("provisionedBandwidthInMbps"u8);
                writer.WriteNumberValue(ProvisionedBandwidthInMbps.Value);
            }
            if (Optional.IsDefined(SessionAddressProvider))
            {
                writer.WritePropertyName("sessionAddressProvider"u8);
                writer.WriteStringValue(SessionAddressProvider.Value.ToString());
            }
            if (Optional.IsDefined(UseForPeeringService))
            {
                writer.WritePropertyName("useForPeeringService"u8);
                writer.WriteBooleanValue(UseForPeeringService.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MicrosoftTrackingId))
            {
                writer.WritePropertyName("microsoftTrackingId"u8);
                writer.WriteStringValue(MicrosoftTrackingId);
            }
            if (Optional.IsDefined(PeeringDBFacilityId))
            {
                writer.WritePropertyName("peeringDBFacilityId"u8);
                writer.WriteNumberValue(PeeringDBFacilityId.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ConnectionState))
            {
                writer.WritePropertyName("connectionState"u8);
                writer.WriteStringValue(ConnectionState.Value.ToString());
            }
            if (Optional.IsDefined(BgpSession))
            {
                writer.WritePropertyName("bgpSession"u8);
                writer.WriteObjectValue(BgpSession, options);
            }
            if (Optional.IsDefined(ConnectionIdentifier))
            {
                writer.WritePropertyName("connectionIdentifier"u8);
                writer.WriteStringValue(ConnectionIdentifier);
            }
            if (options.Format != "W" && Optional.IsDefined(ErrorMessage))
            {
                writer.WritePropertyName("errorMessage"u8);
                writer.WriteStringValue(ErrorMessage);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PeeringDirectConnection IJsonModel<PeeringDirectConnection>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PeeringDirectConnection>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PeeringDirectConnection)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePeeringDirectConnection(document.RootElement, options);
        }

        internal static PeeringDirectConnection DeserializePeeringDirectConnection(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? bandwidthInMbps = default;
            int? provisionedBandwidthInMbps = default;
            PeeringSessionAddressProvider? sessionAddressProvider = default;
            bool? useForPeeringService = default;
            string microsoftTrackingId = default;
            int? peeringDBFacilityId = default;
            PeeringConnectionState? connectionState = default;
            PeeringBgpSession bgpSession = default;
            string connectionIdentifier = default;
            string errorMessage = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("bandwidthInMbps"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    bandwidthInMbps = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("provisionedBandwidthInMbps"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisionedBandwidthInMbps = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("sessionAddressProvider"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sessionAddressProvider = new PeeringSessionAddressProvider(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("useForPeeringService"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    useForPeeringService = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("microsoftTrackingId"u8))
                {
                    microsoftTrackingId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("peeringDBFacilityId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    peeringDBFacilityId = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("connectionState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    connectionState = new PeeringConnectionState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("bgpSession"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    bgpSession = PeeringBgpSession.DeserializePeeringBgpSession(property.Value, options);
                    continue;
                }
                if (property.NameEquals("connectionIdentifier"u8))
                {
                    connectionIdentifier = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("errorMessage"u8))
                {
                    errorMessage = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PeeringDirectConnection(
                bandwidthInMbps,
                provisionedBandwidthInMbps,
                sessionAddressProvider,
                useForPeeringService,
                microsoftTrackingId,
                peeringDBFacilityId,
                connectionState,
                bgpSession,
                connectionIdentifier,
                errorMessage,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<PeeringDirectConnection>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PeeringDirectConnection>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PeeringDirectConnection)} does not support writing '{options.Format}' format.");
            }
        }

        PeeringDirectConnection IPersistableModel<PeeringDirectConnection>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PeeringDirectConnection>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePeeringDirectConnection(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PeeringDirectConnection)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PeeringDirectConnection>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
