// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The state of the connection. </summary>
    public readonly partial struct PeeringConnectionState : IEquatable<PeeringConnectionState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PeeringConnectionState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PeeringConnectionState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string PendingApprovalValue = "PendingApproval";
        private const string ApprovedValue = "Approved";
        private const string ProvisioningStartedValue = "ProvisioningStarted";
        private const string ProvisioningFailedValue = "ProvisioningFailed";
        private const string ProvisioningCompletedValue = "ProvisioningCompleted";
        private const string ValidatingValue = "Validating";
        private const string ActiveValue = "Active";
        private const string TypeChangeRequestedValue = "TypeChangeRequested";
        private const string TypeChangeInProgressValue = "TypeChangeInProgress";

        /// <summary> None. </summary>
        public static PeeringConnectionState None { get; } = new PeeringConnectionState(NoneValue);
        /// <summary> PendingApproval. </summary>
        public static PeeringConnectionState PendingApproval { get; } = new PeeringConnectionState(PendingApprovalValue);
        /// <summary> Approved. </summary>
        public static PeeringConnectionState Approved { get; } = new PeeringConnectionState(ApprovedValue);
        /// <summary> ProvisioningStarted. </summary>
        public static PeeringConnectionState ProvisioningStarted { get; } = new PeeringConnectionState(ProvisioningStartedValue);
        /// <summary> ProvisioningFailed. </summary>
        public static PeeringConnectionState ProvisioningFailed { get; } = new PeeringConnectionState(ProvisioningFailedValue);
        /// <summary> ProvisioningCompleted. </summary>
        public static PeeringConnectionState ProvisioningCompleted { get; } = new PeeringConnectionState(ProvisioningCompletedValue);
        /// <summary> Validating. </summary>
        public static PeeringConnectionState Validating { get; } = new PeeringConnectionState(ValidatingValue);
        /// <summary> Active. </summary>
        public static PeeringConnectionState Active { get; } = new PeeringConnectionState(ActiveValue);
        /// <summary> TypeChangeRequested. </summary>
        public static PeeringConnectionState TypeChangeRequested { get; } = new PeeringConnectionState(TypeChangeRequestedValue);
        /// <summary> TypeChangeInProgress. </summary>
        public static PeeringConnectionState TypeChangeInProgress { get; } = new PeeringConnectionState(TypeChangeInProgressValue);
        /// <summary> Determines if two <see cref="PeeringConnectionState"/> values are the same. </summary>
        public static bool operator ==(PeeringConnectionState left, PeeringConnectionState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PeeringConnectionState"/> values are not the same. </summary>
        public static bool operator !=(PeeringConnectionState left, PeeringConnectionState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PeeringConnectionState"/>. </summary>
        public static implicit operator PeeringConnectionState(string value) => new PeeringConnectionState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PeeringConnectionState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PeeringConnectionState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
