// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Net;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The properties that define a BGP session. </summary>
    public partial class PeeringBgpSession
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PeeringBgpSession"/>. </summary>
        public PeeringBgpSession()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PeeringBgpSession"/>. </summary>
        /// <param name="sessionPrefixV4"> The IPv4 prefix that contains both ends' IPv4 addresses. </param>
        /// <param name="sessionPrefixV6"> The IPv6 prefix that contains both ends' IPv6 addresses. </param>
        /// <param name="microsoftSessionIPv4Address"> The IPv4 session address on Microsoft's end. </param>
        /// <param name="microsoftSessionIPv6Address"> The IPv6 session address on Microsoft's end. </param>
        /// <param name="peerSessionIPv4Address"> The IPv4 session address on peer's end. </param>
        /// <param name="peerSessionIPv6Address"> The IPv6 session address on peer's end. </param>
        /// <param name="sessionStateV4"> The state of the IPv4 session. </param>
        /// <param name="sessionStateV6"> The state of the IPv6 session. </param>
        /// <param name="maxPrefixesAdvertisedV4"> The maximum number of prefixes advertised over the IPv4 session. </param>
        /// <param name="maxPrefixesAdvertisedV6"> The maximum number of prefixes advertised over the IPv6 session. </param>
        /// <param name="md5AuthenticationKey"> The MD5 authentication key of the session. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PeeringBgpSession(string sessionPrefixV4, string sessionPrefixV6, IPAddress microsoftSessionIPv4Address, IPAddress microsoftSessionIPv6Address, IPAddress peerSessionIPv4Address, IPAddress peerSessionIPv6Address, PeeringSessionStateV4? sessionStateV4, PeeringSessionStateV6? sessionStateV6, int? maxPrefixesAdvertisedV4, int? maxPrefixesAdvertisedV6, string md5AuthenticationKey, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SessionPrefixV4 = sessionPrefixV4;
            SessionPrefixV6 = sessionPrefixV6;
            MicrosoftSessionIPv4Address = microsoftSessionIPv4Address;
            MicrosoftSessionIPv6Address = microsoftSessionIPv6Address;
            PeerSessionIPv4Address = peerSessionIPv4Address;
            PeerSessionIPv6Address = peerSessionIPv6Address;
            SessionStateV4 = sessionStateV4;
            SessionStateV6 = sessionStateV6;
            MaxPrefixesAdvertisedV4 = maxPrefixesAdvertisedV4;
            MaxPrefixesAdvertisedV6 = maxPrefixesAdvertisedV6;
            Md5AuthenticationKey = md5AuthenticationKey;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The IPv4 prefix that contains both ends' IPv4 addresses. </summary>
        public string SessionPrefixV4 { get; set; }
        /// <summary> The IPv6 prefix that contains both ends' IPv6 addresses. </summary>
        public string SessionPrefixV6 { get; set; }
        /// <summary> The IPv4 session address on Microsoft's end. </summary>
        public IPAddress MicrosoftSessionIPv4Address { get; set; }
        /// <summary> The IPv6 session address on Microsoft's end. </summary>
        public IPAddress MicrosoftSessionIPv6Address { get; set; }
        /// <summary> The IPv4 session address on peer's end. </summary>
        public IPAddress PeerSessionIPv4Address { get; set; }
        /// <summary> The IPv6 session address on peer's end. </summary>
        public IPAddress PeerSessionIPv6Address { get; set; }
        /// <summary> The state of the IPv4 session. </summary>
        public PeeringSessionStateV4? SessionStateV4 { get; }
        /// <summary> The state of the IPv6 session. </summary>
        public PeeringSessionStateV6? SessionStateV6 { get; }
        /// <summary> The maximum number of prefixes advertised over the IPv4 session. </summary>
        public int? MaxPrefixesAdvertisedV4 { get; set; }
        /// <summary> The maximum number of prefixes advertised over the IPv6 session. </summary>
        public int? MaxPrefixesAdvertisedV6 { get; set; }
        /// <summary> The MD5 authentication key of the session. </summary>
        public string Md5AuthenticationKey { get; set; }
    }
}
