// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The validation state of the ASN associated with the peer. </summary>
    public readonly partial struct PeerAsnValidationState : IEquatable<PeerAsnValidationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PeerAsnValidationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PeerAsnValidationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string PendingValue = "Pending";
        private const string ApprovedValue = "Approved";
        private const string FailedValue = "Failed";

        /// <summary> None. </summary>
        public static PeerAsnValidationState None { get; } = new PeerAsnValidationState(NoneValue);
        /// <summary> Pending. </summary>
        public static PeerAsnValidationState Pending { get; } = new PeerAsnValidationState(PendingValue);
        /// <summary> Approved. </summary>
        public static PeerAsnValidationState Approved { get; } = new PeerAsnValidationState(ApprovedValue);
        /// <summary> Failed. </summary>
        public static PeerAsnValidationState Failed { get; } = new PeerAsnValidationState(FailedValue);
        /// <summary> Determines if two <see cref="PeerAsnValidationState"/> values are the same. </summary>
        public static bool operator ==(PeerAsnValidationState left, PeerAsnValidationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PeerAsnValidationState"/> values are not the same. </summary>
        public static bool operator !=(PeerAsnValidationState left, PeerAsnValidationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PeerAsnValidationState"/>. </summary>
        public static implicit operator PeerAsnValidationState(string value) => new PeerAsnValidationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PeerAsnValidationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PeerAsnValidationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
