// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The LookingGlassSourceType. </summary>
    public readonly partial struct LookingGlassSourceType : IEquatable<LookingGlassSourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LookingGlassSourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LookingGlassSourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EdgeSiteValue = "EdgeSite";
        private const string AzureRegionValue = "AzureRegion";

        /// <summary> EdgeSite. </summary>
        public static LookingGlassSourceType EdgeSite { get; } = new LookingGlassSourceType(EdgeSiteValue);
        /// <summary> AzureRegion. </summary>
        public static LookingGlassSourceType AzureRegion { get; } = new LookingGlassSourceType(AzureRegionValue);
        /// <summary> Determines if two <see cref="LookingGlassSourceType"/> values are the same. </summary>
        public static bool operator ==(LookingGlassSourceType left, LookingGlassSourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LookingGlassSourceType"/> values are not the same. </summary>
        public static bool operator !=(LookingGlassSourceType left, LookingGlassSourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LookingGlassSourceType"/>. </summary>
        public static implicit operator LookingGlassSourceType(string value) => new LookingGlassSourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LookingGlassSourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LookingGlassSourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
