// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The LookingGlassCommand. </summary>
    public readonly partial struct LookingGlassCommand : IEquatable<LookingGlassCommand>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LookingGlassCommand"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LookingGlassCommand(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TracerouteValue = "Traceroute";
        private const string PingValue = "Ping";
        private const string BgpRouteValue = "BgpRoute";

        /// <summary> Traceroute. </summary>
        public static LookingGlassCommand Traceroute { get; } = new LookingGlassCommand(TracerouteValue);
        /// <summary> Ping. </summary>
        public static LookingGlassCommand Ping { get; } = new LookingGlassCommand(PingValue);
        /// <summary> BgpRoute. </summary>
        public static LookingGlassCommand BgpRoute { get; } = new LookingGlassCommand(BgpRouteValue);
        /// <summary> Determines if two <see cref="LookingGlassCommand"/> values are the same. </summary>
        public static bool operator ==(LookingGlassCommand left, LookingGlassCommand right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LookingGlassCommand"/> values are not the same. </summary>
        public static bool operator !=(LookingGlassCommand left, LookingGlassCommand right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LookingGlassCommand"/>. </summary>
        public static implicit operator LookingGlassCommand(string value) => new LookingGlassCommand(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LookingGlassCommand other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LookingGlassCommand other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
