// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The LegacyPeeringsKind. </summary>
    public readonly partial struct LegacyPeeringsKind : IEquatable<LegacyPeeringsKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LegacyPeeringsKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LegacyPeeringsKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DirectValue = "Direct";
        private const string ExchangeValue = "Exchange";

        /// <summary> Direct. </summary>
        public static LegacyPeeringsKind Direct { get; } = new LegacyPeeringsKind(DirectValue);
        /// <summary> Exchange. </summary>
        public static LegacyPeeringsKind Exchange { get; } = new LegacyPeeringsKind(ExchangeValue);
        /// <summary> Determines if two <see cref="LegacyPeeringsKind"/> values are the same. </summary>
        public static bool operator ==(LegacyPeeringsKind left, LegacyPeeringsKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LegacyPeeringsKind"/> values are not the same. </summary>
        public static bool operator !=(LegacyPeeringsKind left, LegacyPeeringsKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LegacyPeeringsKind"/>. </summary>
        public static implicit operator LegacyPeeringsKind(string value) => new LegacyPeeringsKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LegacyPeeringsKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LegacyPeeringsKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
